% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e_conversion.R
\name{checkcoefk}
\alias{checkcoefk}
\title{Check Coefk}
\usage{
checkcoefk(coefk, dim = c(1, 2), STOP = TRUE)
}
\arguments{
\item{coefk}{numeric, matrix or data.frame representing
parameters \code{c(m,g,a,k,w,d,e)}.}

\item{dim}{numeric. Accepted dimension(s) for coefk: 1 for vector, 
2 for matrix, 3 for array. List is not accepted.  
Default is c(1, 2).}

\item{STOP}{boolean. If an error is encountered, TRUE stops
the function and returns an error message. 
FALSE just returns FALSE.}
}
\description{
Check that coefk is either a vector of length 7 or a matrix with 7 columns
or an array with length of last dimension equal to 7.
}
\examples{
    

(coefk <- paramkienerX(getDSdata()))
checkcoefk(coefk)
checkcoefk(t(coefk), STOP = FALSE)

}

