% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/n_regression3.R
\name{fitkienerLX}
\alias{fitkienerLX}
\title{Another Regression Function for Kiener Distributions}
\usage{
fitkienerLX(X, maxk = 10, app = 0, dgts = 9)
}
\arguments{
\item{X}{vector of quantiles.}

\item{maxk}{numeric. The maximum value of tail parameter \code{k}.}

\item{app}{numeric. The parameter "\code{a}" in the function \code{ppoints}.}

\item{dgts}{vector of length 11. Control the rounding of output parameters.}
}
\value{
A vector made of several parts:
\item{rdt}{The return between last and first values calculated through \code{sum(x)}. Thus, assume log-returns.}
\item{coefk}{The regression parameters: \code{c(m, g, a, k, w, d, e)}.}
\item{momk}{The moments related to the parameters: \code{c(m1, sd, sk, ke)}.}
\item{momx}{The moments estimated from the dataset: \code{c(x.m1, x.sd, x.sk, x.ke)}.}
\item{quantk}{Some quantiles:
        \code{c("q.0001", "q.0005", "q.001", "q.005", "q.01", "q.05", "q.10",
        "q.50", "q.90", "q.95", "q.99", "q.995", "q.999", "q.9995", "q.9999")}.}
\item{logisk}{The quantiles corresponding to the logisitic distribution \code{m + 2g logit(p)}}.
\item{dlogisk}{The difference between the logistic quantiles and the true quantiles.}
\item{.........}{.}
\item{.........}{.}
}
\description{
A function to estimate the distribution parameters of a given dataset with
Kiener distributions. The output is a flat vector with the estimated parameters,
the moments (from the parameter and from the dataset), some quantiles.
}
\details{
This function is designed to estimate the parameters of Kiener distributions
for a given dataset.

A typical input is a numeric vector that describes the returns of a stock.
Conversion from a (possible) time series format to a sorted numeric vector
is done automatically and without any check of the initial format.
Missing values \code{NA} are removed. There is no check for \code{NaN},
\code{-Inf}, \code{+Inf}.

Empirical probabilities of each point in the sorted dataset is calculated
with the function \code{\link[stats]{ppoints}}. The parameter \code{app}
corresponds to the parameter \code{a} in \code{ppoints} but has been
limited to the range (0, 0.5). Default value is 0 as large datasets are
very common in finance.

A nonlinear regression is performed with \code{\link[minpack.lm]{nlsLM}}
from the logit of the probabilities \code{logit(p)} over the quantiles X
with the function \code{qlkiener4}.

Tail parameter max values are controlled by \code{maxk}.
An upper value \eqn{maxk = 10} is appropriate for datasets
of low and medium size, less than 50.000 points. For larger datasets, the
upper limit can be extended up to \eqn{maxk = 20}. Such a limit returns
results which are very closed to the logistic distribution, an alternate
distribution which could be more appropriate. Remember
that value \eqn{k < 2} describes distribution with no stable variance and
\eqn{k < 1} describes distribution with no stable mean.

The output is a vector with the regression parameters, some selected moments
estimated from the regression parameters and from the dataset, some quantiles.
See \code{\link{aw2k}} and \code{\link{pk2pk}} for the formulas and
the conversion between the parameters:
\itemize{
  \item{ \code{m} (mu) is the median of the distribution. }
  \item{ \code{g} (gamma) is the scale parameter. }
  \item{ \code{a} (alpha) is the left tail parameter. }
  \item{ \code{k} (kappa) is the harmonic mean of \code{a} and \code{w}
         and describes a global tail parameter. }
  \item{ \code{w} (omega) is the right tail parameter. }
  \item{ \code{d} (delta) is the distorsion parameter. }
  \item{ \code{e} (epsilon) is the eccentricity parameter. }
}
The selected moments are the following:
\itemize{
  \item{ \code{m1} the first moment of the distribution, which is the median, thus equal to \code{m}. }
  \item{ \code{sd} the standard deviation as the square root of centered moment \code{u2} (mu2 in Greek). }
  \item{ \code{sk} the skewness. }
  \item{ \code{ke} the excess of kurtosis. }
  \item{ \code{x.m1} the mean of the data. }
  \item{ \code{x.sd} the square root of the squares of centered data. }
  \item{ \code{sk} the skewness estimated from the centered data at power 3. }
  \item{ \code{ke} the excess of kurtosis estimated from the centered data at power 4. }
}
}
\examples{
require(graphics)
require(minpack.lm)
require(timeSeries)

### Load the datasets and select one number (1-16)
DS     <- getDSdata()
j      <- 5

### and run this block
X      <- DS[[j]]
nameX  <- names(DS)[j]
(fit   <- fitkienerLX(X))
data.frame(X = round(fit, 2))

### Full result. Subsetting is recommended
t(round(sapply(DS, fitkienerLX), 2))
### End block
}
\seealso{
\code{\link{regkienerLX}}, \code{\link{estimkienerX}}.
}

