\name{FastImputation}
\alias{FastImputation}
\title{Use the pattern learned from the training data to impute (fill in good guesses for) missing values.}
\usage{
  FastImputation(x, patterns, verbose = TRUE)
}
\arguments{
  \item{x}{Vector, matrix, dataframe, or object that can be
  coerced into a dataframe, possibly with some missing
  (\code{NA}) values.}

  \item{patterns}{An object of class
  'FastImputationPatterns' generated by
  \code{TrainFastImputation}.}

  \item{verbose}{If TRUE then the progress in imputing the
  data will be shown.}
}
\value{
  An object of class 'FastImputationPatterns' that contains
  information needed later to impute on a single row.
}
\description{
  Like Amelia, FastImputation assumes that the columns of
  the data are multivariate normal or can be transformed
  into approximately multivariate normal.
}
\examples{
data(FItrain)   # provides FItrain dataset
patterns <- TrainFastImputation(FItrain)

data(FItest)
FItest          # note there is missing data
imputed.data <- FastImputation(FItest, patterns)
imputed.data    # good guesses for missing values are filled in

data(FItrue)
imputation.rmse <- sqrt(sum( (imputed.data - FItrue)^2 )/sum(is.na(FItest)))
imputation.rmse
}
\author{
  Stephen R. Haptonstahl \email{srh@haptonstahl.org}
}
\references{
  \url{http://gking.harvard.edu/amelia/}
}
\seealso{
  \code{\link{TrainFastImputation}}
}

