% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{plot.farm.scree}
\alias{plot.farm.scree}
\title{Diagnostic plots from factor-finding}
\usage{
\method{plot}{farm.scree}(x, scree.plot = TRUE, ratio.plot = TRUE,
  col = "red", ...)
}
\arguments{
\item{x}{A "\code{farm.scree}" object.}

\item{scree.plot}{\emph{optional} indicating whether to show the scree plot. Default TRUE}

\item{ratio.plot}{\emph{optional} indicating whether to show the scree plot. Default TRUE.}

\item{col}{Controls the color of the maximim eigenvalue dot. Defaut "red".}

\item{\dots}{graphical parameters to \code{\link{plot}}.}
}
\value{
Two plots: First plot is the scree plot of the data. Second plot illustrates the eigenvalue ratio test.
}
\description{
Plot method for \code{farm.scree} objects. Plots the eigenvalue ratio plot and the scree plot.
}
\details{
By default, two plots are output with default options. To customize plots, plot one at a time and customize.
}
\examples{
set.seed(100)
p = 100
n = 20
epsilon = matrix(rnorm( p*n, 0,1), nrow = n)
B = matrix(rnorm(p*3,0,1), nrow=p)
fx = matrix(rnorm(3*n, 0,1), nrow = n)
X = fx\%*\%t(B)+ epsilon
output = farm.scree(X)
plot(output)
plot(output, ratio.plot=FALSE, main="My Title")
}
\seealso{
\code{\link{farm.scree}} and \code{\link{print.farm.scree}}
}
