% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftrlprox.formula.r
\name{ftrlprox.formula}
\alias{ftrlprox.formula}
\title{FTRL Proximal formula}
\usage{
\method{ftrlprox}{formula}(formula, data, lambda, alpha, a, b = 1,
  num_epochs = 1, save_loss = F, ...)
}
\arguments{
\item{formula}{modeling formula}

\item{data}{data.frame containing features and dependent variable}

\item{lambda}{regularization term}

\item{alpha}{mixing parameter, alpha=0 corresponds to L2 regularization and alpha=1 to L1.}

\item{a}{learning rate parameter}

\item{b}{learning rate parameter controlling decay, defaults to 1.}

\item{num_epochs}{number of times we should traverse over the traiing set, defaults to 1.}

\item{save_loss}{is to save the loss function during training.}

\item{...}{additional args}
}
\value{
ftrlprox model object
}
\description{
Online elastic net regression using the FTRL Proximal algorithm for training.
}
\details{
Test text
}
\examples{
require(mlbench)

p <- mlbench.circle(100,2)
dat <- as.data.frame(p)

mdl <- ftrlprox(classes ~ x.1 + x.2 + I(x.1^2) + I(x.2^2), dat,
                a = 0.3, lambda = 5.0, alpha = 1.0)
print(mdl)
}
\author{
Vilhelm von Ehrenheim
}

