% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exhaustiveSearch.R
\name{breadthFirst}
\alias{breadthFirst}
\title{Breadth First Search (exhaustive search)}
\usage{
breadthFirst()
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on the breadth first search. This function is called internally within the \code{\link{searchAlgorithm}} function. Breadth First Search searches the whole features subset in breadth first order \insertCite{Kozen1992}{FSinR}.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space
## Classification problem

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('determinationCoefficient')

# Generates the search function with Breadth first
bfs_search <- breadthFirst()
# Performs the search process directly (parameters: dataset, target variable and evaluator)
bfs_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
