## Test Messages ----
test_that("binCI() messages",{
  expect_error(binCI(-1,10),"must be non-negative")
  expect_error(binCI(1,-10),"must be non-negative")
  expect_error(binCI(11,10),"must not be greater than")
  expect_error(binCI("a",10),"must be whole numbers")
  expect_error(binCI(1,"a"),"must be whole numbers")
  expect_error(binCI(c(-1,2),10),"must be non-negative")
  expect_error(binCI(1,c(-1,10)),"must be non-negative")
  expect_error(binCI(1.1,10),"must be whole numbers")
  expect_error(binCI(1,10.1),"must be whole numbers")
  expect_error(binCI(c(1,1.1),10),"must be whole numbers")
  expect_error(binCI(1,c(9.1,10)),"must be whole numbers")
  expect_error(binCI(c(1,10),5),"must not be greater than")
  expect_error(binCI(c(1,10),c(5,9)),"must not be greater than")
  expect_error(binCI(6,c(5,9)),"must not be greater than")
  expect_error(binCI(6,10,type="derek"),"should be one of")
  expect_error(binCI(6,10,conf.level=0),"must be between 0 and 1")
  expect_error(binCI(6,10,conf.level=1),"must be between 0 and 1")
  expect_warning(binCI(6:9,10),"Can't use multiple 'type's with multiple 'x's")
  expect_error(binCI(data.frame(d=6:9),10),"'x' must be a single or vector")
  expect_error(binCI(2,data.frame(d=6:9)),"'n' must be a single or vector")
})

test_that("hyperCI() messages",{
  expect_error(hyperCI(-1,10,5),"must all be non-negative")
  expect_error(hyperCI(1,-10,5),"must all be non-negative")
  expect_error(hyperCI(1,10,-5),"must all be non-negative")
  expect_error(hyperCI(1,10,5),"'m' must be less than 'M'")
  expect_error(hyperCI(15,5,10),"'m' must be less than 'n'")
  expect_error(hyperCI("a",10,5),"must all be whole numbers")
  expect_error(hyperCI(15,"a",5),"must all be whole numbers")
  expect_error(hyperCI(15,10,"a"),"must all be whole numbers")
  expect_error(hyperCI(20.1,10,5),"must be a whole number")
  expect_error(hyperCI(15,10.1,5),"must be a whole number")
  expect_error(hyperCI(15,10,5.1),"must be a whole number")
  expect_error(hyperCI(c(15,15),10,5),"be a single value")
  expect_error(hyperCI(15,c(10,10),5),"be a single value")
  expect_error(hyperCI(15,10,c(5,5)),"be a single value")
  expect_error(hyperCI(c(15,15),c(10,10),c(5,5)),"be a single value")
  expect_error(hyperCI(15,10,5,conf.level=0),"must be between 0 and 1")
  expect_error(hyperCI(15,10,5,conf.level=1),"must be between 0 and 1")
})

test_that("poiCI() messages",{
  expect_error(poiCI(6,type="derek"),"should be one of")
  expect_error(poiCI(-1),"must be non-negative")
  expect_error(poiCI(c(-1,1:3)),"must be non-negative")
  expect_error(poiCI("a"),"must be a whole number")
  expect_error(poiCI(1.1),"must be a whole number")
  expect_error(poiCI(6,conf.level=0),"must be between 0 and 1")
  expect_error(poiCI(6,conf.level=1),"must be between 0 and 1")
  expect_warning(poiCI(6:9),"Can't use multiple 'type's with multiple 'x's")
  expect_error(poiCI(data.frame(d=6:9)),"'x' must be a single or vector")
})


## Test Output Types ----
test_that("binCI() output types",{
  res <- binCI(7,10)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),3)
  expect_equal(ncol(res),2)  
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Wilson","Asymptotic"))
  res <- binCI(c(3,7),10,type="wilson")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)  
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- binCI(c(3,7),10,type="exact")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)  
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- binCI(c(3,7),10,type="asymptotic")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)  
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  
  res <- binCI(7,10,verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),3)
  expect_equal(ncol(res),5)
  expect_equal(colnames(res),c("x","n","proportion","95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Wilson","Asymptotic"))
  res <- binCI(c(3,7),10,type="wilson",verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),5)  
  expect_equal(colnames(res),c("x","n","proportion","95% LCI","95% UCI"))
  res <- binCI(c(3,7),10,type="exact",verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),5)  
  expect_equal(colnames(res),c("x","n","proportion","95% LCI","95% UCI"))
  res <- binCI(c(3,7),10,type="asymptotic",verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),5)  
  expect_equal(colnames(res),c("x","n","proportion","95% LCI","95% UCI"))
})

test_that("hyperCI() output types",{
  res <- hyperCI(20,20,10)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
})

test_that("poiCI() output types",{
  res <- poiCI(10)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),4)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Daly","Byar","Asymptotic"))
  res <- poiCI(10,type="exact")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10,type="daly")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10,type="byar")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10,type="asymptotic")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10,type=c("exact","daly"))
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Daly"))
  res <- poiCI(10,type="exact",verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),3)
  expect_equal(colnames(res),c("x","95% LCI","95% UCI"))
  expect_equal(rownames(res),"Exact")
  res <- poiCI(10,type=c("exact","daly"),verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),3)
  expect_equal(colnames(res),c("x","95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Daly"))
  
  res <- poiCI(10:11,type="exact")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10:11,type="daly")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10:11,type="byar")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10:11,type="asymptotic")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  
  res <- poiCI(0)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),4)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Daly","Byar","Asymptotic"))
})


## Validate Results ----
test_that("binCI() compared to epitools functions",{
  res <- as.data.frame(binCI(7,10,verbose=TRUE))
  resepi <- rbind(epitools::binom.exact(7,10),
                  epitools::binom.wilson(7,10),
                  epitools::binom.approx(7,10))[,-6]
  rownames(resepi) <- c("Exact","Wilson","Asymptotic")
  expect_equivalent(res,resepi)
  
  res <- as.data.frame(binCI(5:7,10,type="wilson",verbose=TRUE))
  resepi <- epitools::binom.wilson(5:7,10)[,-6]
  expect_equivalent(res,resepi)
})

test_that("poiCI() compared to epitools functions",{
  res <- as.data.frame(poiCI(10,verbose=TRUE))
  resepi <- rbind(epitools::pois.exact(10),
                  epitools::pois.daly(10),
                  epitools::pois.byar(10),
                  epitools::pois.approx(10))[,-c(2,3,6)]
  rownames(resepi) <- c("Exact","Daly","Byar","Asymptotic")
  expect_equivalent(res,resepi)
  
  res <- as.data.frame(poiCI(5:7,type="exact",verbose=TRUE))
  resepi <- epitools::pois.exact(5:7)[,-c(2,3,6)]
  expect_equivalent(res,resepi)
})

