\name{createFLAccesors}
\alias{createFLAccesors}
\title{Create accesor and replecement methods for slots of complex classes}
\description{
	A function is provided to generate accesor and replacement methods for each slot of a
	complex class. If a slot name matches that of an existing method or function, the new
	methdos are only created if the signature is \code{(object, ...)}. Otherwise a warning
	is issued for this slot and the method declaration is started for the next slot.
}
\usage{
createFLAccesors(object, exclude=character(1))
}
\arguments{
  \item{object}{An object of any S4 class}
  \item{exclude}{A character vector with the classes of the slots for which methods are NOT to
  			   be created.}
}
\details{
	This function provides a simplified way for creating accesor and replecement methods for complex
	classes at load time. But very limited checks are carried out, so care should be taken when using
	it. A direct call to the function for a newly defined class should be attempted before including a
	call in any package, and careful examination of the methods generated and of any warning or error
	message should be carried out.

	The main use of this function is for the complex objects defined in the FLCore package (see for
	example \code{\link{FLStock-class}}). The \emph{range} slot present in all FLCore objects does not
	need to be accessed directly, as the information there stored is accesible through the
	\code{\link{dims}} method.
}
\value{
	A list is returned containing the names of the slots for which both accesor and replacement methods
	have been defined. This is useful for initial calls and debugging, but calls inside the package can
	be made silent by using \code{\link{invisible}()}.
}
\author{FLR Team}
\seealso{
	For examples of the methods generated by \code{createFLAccesors}, look at the slots in
		     \code{\link{FLStock-class}}.
}
\examples{
	\dontrun{
	setClass("example", representation(name="character", quantity="vector"))
	ex <- new("example", name="example", quantity=rnorm(10))
	createFLAccesors(ex)
	quantity(ex)
	name(ex) <- 'Modified example'
	name(ex)
	}
}
\keyword{methods}
\keyword{utilities}
