% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFTreesdata_doc.R
\docType{data}
\name{mushrooms}
\alias{mushrooms}
\title{Mushrooms data}
\format{
A data frame containing 8,124 rows and 23 columns.

See \url{http://archive.ics.uci.edu/ml/machine-learning-databases/mushroom/agaricus-lepiota.names} for column descriptions.

 \describe{
 \item{poisonous}{\emph{Criterion}: Is the mushroom poisonous?

  Values: \code{TRUE} (poisonous) vs. \code{FALSE} (eatable) (48.2\% vs.\ 52.8\%).}
 \item{cshape}{cap-shape, character (bell=b, conical=c, convex=x, flat=f, knobbed=k, sunken=s)}
 \item{csurface}{cap-surface, character (fibrous=f, grooves=g, scaly=y, smooth=s)}
 \item{ccolor}{cap-color, character (brown=n, buff=b, cinnamon=c, gray=g, green=r, pink=p, purple=u, red=e, white=w, yellow=y)}
 \item{bruises}{Are there bruises? logical (TRUE/FALSE)}
 \item{odor}{character (almond=a, anise=l, creosote=c, fishy=y, foul=f, musty=m, none=n, pungent=p, spicy=s) }
 \item{gattach}{gill-attachment, character (attached=a, descending=d, free=f, notched=n)}
 \item{gspace}{gill-spacing, character (close=c, crowded=w, distant=d)}
 \item{gsize}{gill-size, character (broad=b, narrow=n)}
 \item{gcolor}{gill-color, character (black=k, brown=n, buff=b, chocolate=h, gray=g, green=r, orange=o, pink=p, purple=u, red=e, white=w, yellow=y)}
 \item{sshape}{stalk-shape, character (enlarging=e, tapering=t)}
 \item{sroot}{stalk-root, character (bulbous=b ,club=c, cup=u, equal=e, rhizomorphs=z, rooted=r)}
 \item{ssaring}{stalk-surface-above-ring, character (fibrous=f, scaly=y, silky=k, smooth=s)}
 \item{ssbring}{stalk-surface-below-ring, character (fibrous=f, scaly=y, silky=k, smooth=s)}
 \item{scaring}{stalk-color-above-ring, character (brown=n, buff=b, cinnamon=c, gray=g, orange=o, pink=p, red=e, white=w, yellow=y)}
 \item{scbring}{stalk-color-below-ring, character (brown=n, buff=b, cinnamon=c, gray=g, orange=o, pink=p, red=e, white=w, yellow=y)}
 \item{vtype}{veil-type, character (partial=p, universal=u)}
 \item{vcolor}{veil-color, character (brown=n, orange=o, white=w, yellow=y)}
 \item{ringnum}{character (none=n, one=o, two=t)}
 \item{ringtype}{character (cobwebby=c, evanescent=e, flaring=f, large=l, none=n, pendant=p, sheathing=s, zone=z)}
 \item{sporepc}{spore-print-color, character (black=k, brown=n, buff=b, chocolate=h, green=r, orange=o, purple=u, white=w, yellow=y)}
 \item{population}{character(abundant=a, clustered=c, numerous=n, scattered=s, several=v, solitary=y)}
 \item{habitat}{character (grasses=g, leaves=l, meadows=m, paths=p, urban=u, waste=w, woods=d)}

}
}
\source{
\url{https://archive.ics.uci.edu/ml/datasets/Mushroom}
}
\usage{
mushrooms
}
\description{
Data describing poisonous vs. non-poisonous mushrooms.
}
\details{
This dataset includes descriptions of hypothetical samples corresponding to 23 species of gilled mushrooms
in the Agaricus and Lepiota Family. Each species is classified as \code{poisonous} (True or False).
The Guide clearly states that there is no simple rule for determining the edibility of a mushroom;
no rule like ``leaflets three, let it be'' for Poisonous Oak and Ivy.


We made the following enhancements to the original data for improved usability:

\itemize{

 \item{Any missing values, denoted as "?" in the dataset, were transformed into NAs.}

 \item{Binary factor variables with exclusive "t" and "f" values were converted to logical \code{TRUE/FALSE} vectors.}

 \item{The binary factor \emph{criterion} variable with exclusive "p" and "e" values was converted to a logical \code{TRUE/FALSE} vector.}

 }

 Other than that, the data remains consistent with the original dataset.
}
\references{
Mushroom records drawn from The Audubon Society Field Guide to North American Mushrooms (1981).
G.H. Lincoff (Pres.), New York: A.A. Knopf.
}
\seealso{
Other datasets: 
\code{\link{blood}},
\code{\link{breastcancer}},
\code{\link{car}},
\code{\link{contraceptive}},
\code{\link{creditapproval}},
\code{\link{fertility}},
\code{\link{forestfires}},
\code{\link{heart.cost}},
\code{\link{heart.test}},
\code{\link{heart.train}},
\code{\link{heartdisease}},
\code{\link{iris.v}},
\code{\link{sonar}},
\code{\link{titanic}},
\code{\link{voting}},
\code{\link{wine}}
}
\concept{datasets}
\keyword{datasets}
