% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{AIC.femlm}
\alias{AIC.femlm}
\title{Aikake's an information criterion}
\usage{
\method{AIC}{femlm}(object, ..., k = 2)
}
\arguments{
\item{object}{An object of class \code{femlm}. Typically the result of a \code{\link[FENmlm]{femlm}} estimation.}

\item{...}{Optionally, more fitted objects.}

\item{k}{A numeric, the penalty per parameter to be used; the default k = 2 is the classical AIC (i.e. \code{AIC=-2*LL+k*nparams}).}
}
\value{
It return a numeric vector, with length the same as the number of objects taken as arguments.
}
\description{
This function computes the AIC (Aikake's, an information criterion) from a \code{\link[FENmlm]{femlm}} estimation.
}
\details{
The AIC is computed as:
\deqn{AIC = -2\times LogLikelihood + k\times nbParams}
with k the penalty parameter.

You can have more information on this crtierion on \code{\link[stats]{AIC}}.
}
\examples{

# two fitted models with different expl. variables:
res1 = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
            Petal.Width | Species, iris)
res2 = femlm(Sepal.Length ~ Petal.Width | Species, iris)

AIC(res1, res2)
BIC(res1, res2)


}
\seealso{
\code{\link[FENmlm]{femlm}}, \code{\link[FENmlm]{AIC.femlm}}, \code{\link[FENmlm]{logLik.femlm}}, \code{\link[FENmlm]{nobs.femlm}}.
}
\author{
Laurent Berge
}
