% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/crossvalidation.R
\name{validateFDboost}
\alias{cvLong}
\alias{cvMa}
\alias{cvrisk.FDboost}
\alias{validateFDboost}
\title{Cross-Validation and Bootstrapping over Curves}
\usage{
validateFDboost(object, response = NULL, folds = cv(rep(1,
  length(unique(object$id))), type = "bootstrap"), grid = 1:mstop(object),
  getCoefCV = TRUE, riskopt = c("mean", "median"), mrdDelete = 0,
  refitSmoothOffset = TRUE, showProgress = TRUE, ...)

\method{cvrisk}{FDboost}(object, folds = cvLong(id = object$id, weights =
  model.weights(object)), grid = 1:mstop(object), papply = mclapply,
  fun = NULL, corrected = TRUE, ...)

cvLong(id, weights = rep(1, l = length(id)), type = c("bootstrap", "kfold",
  "subsampling", "curves"), B = ifelse(type == "kfold", 10, 25), prob = 0.5,
  strata = NULL)

cvMa(ydim, weights = rep(1, l = ydim[1] * ydim[2]), type = c("bootstrap",
  "kfold", "subsampling", "curves"), B = ifelse(type == "kfold", 10, 25),
  prob = 0.5, strata = NULL, ...)
}
\arguments{
\item{object}{fitted FDboost-object}

\item{response}{optional, specify a response vector for the computation of the prediction errors.
Defaults to \code{NULL} which means that the response of the fitted model is used.}

\item{folds}{a weight matrix with number of rows equal to the number of observed trajectories.}

\item{grid}{the grid over which the optimal number of boosting iterations (mstop) is searched.}

\item{getCoefCV}{logical, defaults to \code{TRUE}. Should the coefficients and predictions
be computed for all the models on the sampled data?}

\item{riskopt}{how is the optimal stopping iteration determined. Defaults to the mean,
but median is possible as well.}

\item{mrdDelete}{Delete values that are \code{mrdDelete} percent smaller than the mean
of the response. Defaults to 0 which means that only response values being 0
are not used in the calculation of the MRD (= mean relative deviation).}

\item{refitSmoothOffset}{logical, should the offset be refitted in each learning sample?
Defaults to \code{TRUE}. In \code{\link[mboost]{cvrisk}} the offset of the original model fit in
\code{object} is used in all folds.}

\item{showProgress}{logical, defaults to \code{TRUE}.}

\item{...}{further arguments passed to \code{\link[parallel]{mclapply}}}

\item{papply}{(parallel) apply function, defaults to \code{\link[parallel]{mclapply}},
see \code{\link[mboost]{cvrisk}} for details.}

\item{fun}{if \code{fun} is \code{NULL}, the out-of-sample risk is returned.
\code{fun}, as a function of \code{object},
may extract any other characteristic of the cross-validated models. These are returned as is.}

\item{corrected}{see \code{\link[mboost]{cvrisk}}.}

\item{id}{the id-vector as integers 1, 2, ... specifying which observations belong to the same curve,
deprecated in \code{cvMa()}.}

\item{weights}{a numeric vector of (integration) weights, defaults to 1.}

\item{type}{character argument for specifying the cross-validation
method. Currently (stratified) bootstrap, k-fold cross-validation, subsampling and
leaving-one-curve-out cross validation (i.e. jack knife on curves) are implemented.}

\item{B}{number of folds, per default 25 for \code{bootstrap} and
\code{subsampling} and 10 for \code{kfold}.}

\item{prob}{percentage of observations to be included in the learning samples
for subsampling.}

\item{strata}{a factor of the same length as \code{weights} for stratification.}

\item{ydim}{dimensions of response-matrix}
}
\value{
\code{cvMa} and \code{cvLong} return a matrix of weights to be used in \code{cvrisk}.
The function \code{validateFDboost} returns a validateFDboost-object, which is a named list containing:
\item{response}{the response}
\item{yind}{the observation points of the response}
\item{id}{the id variable of the response}
\item{folds}{folds that were used}
\item{grid}{grid of possible numbers of boosting iterations}
\item{coefCV}{if \code{getCoefCV} is \code{TRUE} the estimated coefficient functions in the folds}
\item{predCV}{if \code{getCoefCV} is \code{TRUE} the out-of-bag predicted values of the response}
\item{oobpreds}{if the type of folds is curves the out-of-bag predictions for each trajectory}
\item{oobrisk}{the out-of-bag risk}
\item{oobriskMean}{the out-of-bag risk at the minimal mean risk}
\item{oobmse}{the out-of-bag mean squared error (MSE)}
\item{oobrelMSE}{the out-of-bag relative mean squared error (relMSE)}
\item{oobmrd}{the out-of-bag mean relative deviation (MRD)}
\item{oobrisk0}{the out-of-bag risk without consideration of integration weights}
\item{oobmse0}{the out-of-bag mean squared error (MSE) without consideration of integration weights}
\item{oobmrd0}{the out-of-bag mean relative deviation (MRD) without consideration of integration weights}
}
\description{
Function \code{validateFDboost()} is experimental.
Cross-Validation and bootstrapping over curves to compute the empirical risk for
hyper-parameter selection and to compute resampled coefficients and predictions for
the models.
}
\details{
The number of boosting iterations is an important hyper-parameter of the boosting algorithms
and can be chosen using the functions \code{cvrisk.FDboost} and \code{validateFDboost} as they compute
honest, i.e. out-of-bag, estimates of the empirical risk for different numbers of boosting iterations.
The weights (zero weights correspond to test cases) are defined via the folds matrix,
see \code{\link[mboost]{cvrisk}} in package mboost.

The function \code{validateFDboost} is especially suitable for models with functional response.
Using the option \code{refitSmoothOffset} the offset is refitted on each fold.
Note, that the function \code{validateFDboost} expects folds that give weights
per trajectory without considering integration weights. The integration weights of
\code{object} are used to compute the empirical risk as integral. The argument \code{response}
can be useful in simulation studies where the true value of the response is known but for
the model fit the response is used with noise.

The function \code{cvrisk.FDboost} is a wrapper for \code{\link[mboost]{cvrisk}} in package mboost.
It overrieds the default for the folds, so that the folds are sampled on the level of curves
(not on the level of single observations, which does not make sense for functional response).
Note that the offset is not part of the refitting if \code{cvrisk} is used.
Per default the integration weights of the model fit are used to compute the prediction errors
(as the integration weights are part of the default folds).
Note that in \code{cvrisk} the weights are rescaled to sum up to one.

The functions \code{cvMa} and \code{cvLong} can be used to build an appropriate
weight matrix for functional response to be used with \code{cvrisk} as sampling
is done on the level of curves. The probability for each
trajectory to enter a fold is equal over all trajectories.
The function \code{cvMa} takes the dimensions of the response matrix as input argument and thus
can only be used for regularly observed response.
The function \code{cvLong} takes the id variable and the weights as arguments and thus can be used
for responses in long format that are potentially observed irregularly.

If \code{strata} is defined
sampling is performed in each stratum separately thus preserving
the distribution of the \code{strata} variable in each fold.
}
\note{
Use argument \code{mc.cores = 1L} to set the numbers of cores that is used in
parallel computation. On Windows only 1 core is possible, \code{mc.cores = 1}, which is the default.
}
\examples{
Ytest <- matrix(rnorm(15), ncol = 3) # 5 trajectories, each with 3 observations
Ylong <- as.vector(Ytest)
## 4-folds for bootstrap for the response in long format without integration weights
cvMa(ydim = c(5,3), type = "bootstrap", B = 4)
cvLong(id = rep(1:5, times = 3), type = "bootstrap", B = 4)

## Example for function-on-scalar-regression to optimize mstop
data("viscosity", package = "FDboost")
## set time-interval that should be modeled
interval <- "101"

## model time until "interval" and take log() of viscosity
end <- which(viscosity$timeAll == as.numeric(interval))
viscosity$vis <- log(viscosity$visAll[,1:end])
viscosity$time <- viscosity$timeAll[1:end]
# with(viscosity, funplot(time, vis, pch = 16, cex = 0.2))

## fit median regression model with 100 boosting iterations,
## step-length 0.4 and smooth time-specific offset
## the factors are in effect coding -1, 1 for the levels
mod1 <- FDboost(vis ~ 1 + bols(T_C, contrasts.arg = "contr.sum", intercept=FALSE)
               + bols(T_A, contrasts.arg = "contr.sum", intercept=FALSE),
               timeformula = ~bbs(time, lambda=100),
               numInt = "equal", family = QuantReg(),
               offset = NULL, offset_control = o_control(k_min = 9),
               data = viscosity, control = boost_control(mstop = 100, nu = 0.4))
summary(mod1)
## plot(mod1)

## for the example B is set to a small value so that bootstrap is fast
val1 <- validateFDboost(mod1, folds = cvLong(unique(mod1$id), B = 2) )

\dontrun{
## the same, as folds are equal
val1 <- validateFDboost(mod1, folds = cv(rep(1, 64), B = 2) )
## plot the risk per fold against the number of boosting-iterations
plot(val1)
## plot the coefficients in the folds with point-wise intervals for base-learner 1
plotPredCoef(val1, terms = FALSE, which = 1)
mstop(val1)
}

\dontrun{
## do a leaving-one-curve-out cross-validation, takes some time!
val2 <- validateFDboost(mod1, folds = cvLong(unique(mod1$id), type = "curves") )
plot(val2)
plotPredCoef(val2, which = 1) # plot oob predictions per fold
plotPredCoef(val2, which = 1, terms = FALSE) # plot coefficients per fold
}

## find the optimal mstop over 2-fold bootstrap
## using the function cvrisk, offset is not refitted!
folds1 <- cvLong(id = mod1$id, weights = model.weights(mod1),
                 type = "bootstrap", B = 2)
cvm1 <- cvrisk(mod1, folds = folds1)
## plot(cvm1)
mstop(cvm1)
}
\seealso{
\code{\link{cvrisk}} to perform cross-validation with scalar response.
}

