% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/baselearners.R
\name{integrationWeights}
\alias{integrationWeights}
\alias{integrationWeightsLeft}
\title{Functions to compute integration weights}
\usage{
integrationWeights(X1, xind, id = NULL)

integrationWeightsLeft(X1, xind, leftWeight = c("first", "mean", "zero"))
}
\arguments{
\item{X1}{matrix of functional variable}

\item{xind}{index of functional variable}

\item{id}{defaults to NULL if X1 is a matrix. identity variable if X1 is in long format.}

\item{leftWeight}{one of \code{c("mean", "first", "zero")}. With left Riemann sums
different assumptions for the weight of the first observation are possible.
The default is to use the mean over all integration weights, \code{"mean"}.
Alternative one can use the first integration weight, \code{"first"}, or
use distance to zero, \code{"zero"}.}
}
\description{
Computes trapezoidal integration weights for a functional variable X1 on grid xind.
}
\details{
The function \code{integrationWeights()} computes trapezoidal integration weights,
 that are symmetric. Per default those weights are use in the \code{\link{bsignal}}-base-learner.
 The function \code{integrationWeightsLeft()} computes weights,
 that take into account only the distance to the prior observation point.
 Thus one has to decide what to do with the first observation.
 Those left weights are adequate for historical effects like in \code{\link{bhist}}.
}
\examples{
## Example for trapezoidal integration weights
xind0 <- seq(0,1,l=5)
xind <- c(0, 0.1, 0.3, 0.7, 1)
X1 <- matrix(xind^2, ncol=length(xind0), nrow=2)

# Regualar observation points
integrationWeights(X1, xind0)
# Irregular observation points
integrationWeights(X1, xind)

# with missing value
X1[1,2] <- NA
integrationWeights(X1, xind0)
integrationWeights(X1, xind)

## Example for left integration weights
xind0 <- seq(0,1,l=5)
xind <- c(0, 0.1, 0.3, 0.7, 1)
X1 <- matrix(xind^2, ncol=length(xind0), nrow=2)

# Regualar observation points
integrationWeightsLeft(X1, xind0, leftWeight="mean")
integrationWeightsLeft(X1, xind0, leftWeight="first")
integrationWeightsLeft(X1, xind0, leftWeight="zero")

# Irregular observation points
integrationWeightsLeft(X1, xind, leftWeight="mean")
integrationWeightsLeft(X1, xind, leftWeight="first")
integrationWeightsLeft(X1, xind, leftWeight="zero")

# obervation points that do not start with 0
xind2 <- xind + 0.5
integrationWeightsLeft(X1, xind2, leftWeight="zero")
}
\seealso{
\code{\link{bsignal}} and \code{\link{bhist}} for the base-learners.
}

