% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{funRsquared}
\alias{funRsquared}
\title{Functional R-squared}
\usage{
funRsquared(object, overTime = TRUE, breaks = object$yind, global = FALSE,
  ...)
}
\arguments{
\item{object}{fitted FDboost-object}

\item{overTime}{per default the functional R-squared is calculated over time
if \code{overTime=FALSE}, the R-squared is calculated per curve}

\item{breaks}{an optional vector or number giving the time-points at which the model is evaluated.
Can be specified as number of equidistant time-points or as vector of time-points.
Defaults to the index of the response in the model.}

\item{global}{logical. defaults to \code{FALSE},
if TRUE the global R-squared like in a normal linear model is calculated}

\item{...}{currently not used}
}
\value{
Returns a vector with the calculated R-squared and some extra information in attributes.
}
\description{
Calculates the functional R-squared for a fitted FDboost-object
}
\details{
\code{breaks} should be set to some grid, if there are many
missing values or time-points with very few observations in the dataset.
Otherwise at these points of t the variance will be almost 0
(or even 0 if there is only one observation at a time-point),
and then the prediction by the local means \eqn{\mu(t)} is locally very good.
The observations are interpolated linearly if necessary.

Formula to calculate R-squared over time, \code{overTime=TRUE}: \cr
\eqn{R^2(t) = 1 - \sum_{i}( Y_i(t) - \hat{Y}_i(t))^2 /  \sum_{i}( Y_i(t) - \bar{Y}(t) )^2 }

Formula to calculate R-squared over subjects, \code{overTime=FALSE}: \cr
\eqn{R^2_i = 1 - \int (Y_i(t) - \hat{Y}_i(t))^2 dt /  \int (Y_i(t) - \bar{Y}_i )^2 dt }
}
\note{
\code{breaks} cannot be changed in the case the \code{bsignal()}
is used over the same domain
as the response! In that case you would have to rename the index of the response or that
of the covariates.
}
\references{
Ramsay, J., Silverman, B. (2006). Functional data analysis.
Wiley Online Library. chapter 16.3
}

