% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_post.R
\name{GetCharPolyRoots}
\alias{GetCharPolyRoots}
\title{Roots of the Characteristic Polynomial}
\usage{
GetCharPolyRoots(coeffs, opt, k, r, p)
}
\arguments{
\item{coeffs}{A list of coefficients for the FCVAR model.
An element of the list of estimation \code{results} output from \code{FCVARestn}.}

\item{opt}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options,
generated from \code{FCVARoptions()}.}

\item{k}{The number of lags in the system.}

\item{r}{The cointegrating rank.}

\item{p}{The number of variables in the system.}
}
\value{
An S3 object of type \code{FCVAR_roots} with the following elements:
\describe{
  \item{\code{cPolyRoots}}{A vector of the roots of the characteristic polynomial.
    It is an element of the list of estimation \code{results} output from \code{FCVARestn}.}
  \item{\code{b}}{A numeric value of the fractional cointegration parameter.}
}
}
\description{
\code{GetCharPolyRoots} calculates the roots of the
characteristic polynomial and plots them with the unit circle
transformed for the fractional model, see Johansen (2008).
\code{summary.FCVAR_roots} prints the output of
\code{GetCharPolyRoots} to screen.
}
\note{
The roots are calculated from the companion form of the VAR,
where the roots are given as the inverse eigenvalues of the
coefficient matrix.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
results <- FCVARestn(x, k = 2, r = 1, opt)
FCVAR_CharPoly <- GetCharPolyRoots(results$coeffs, opt, k = 2, r = 1, p = 3)
}
}
\references{
Johansen, S. (2008). "A representation theory for a class of
vector autoregressive models for fractional processes,"
Econometric Theory 24, 651-676.
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} to estimate the model for which to calculate the roots
of the characteristic polynomial.
\code{summary.FCVAR_roots} prints the output of
\code{GetCharPolyRoots} to screen.

Other FCVAR postestimation functions: 
\code{\link{FCVARboot}()},
\code{\link{FCVARhypoTest}()},
\code{\link{MVWNtest}()},
\code{\link{plot.FCVAR_roots}()},
\code{\link{summary.FCVAR_roots}()},
\code{\link{summary.MVWN_stats}()}
}
\concept{FCVAR postestimation functions}
