\name{Leukemia}
\alias{Leukemia}

\docType{data}
\title{
Leukemia Distancematrix and classificiation used in [Thrun, 2018]
}
\description{
Data is anonymized. Original dataset was pubished in [Haferlach et al., 2010]. Original dataset had around 12.000 Dimensions.
Detailed descriptions of preprocessed dataset and its clustering challenge is provided in [Thrun/Ultsch, 2020].
}
\usage{data("Leukemia")}

\details{
554x554 distance matrix.
Cls defines the following clusters:

1= APL Outlier

2=APL

3=Healthy

4=AML

5=CLL

6=CLL Outlier

}

\references{
[Thrun, 2018]  Thrun, M. C.: Projection Based Clustering through Self-Organization and Swarm Intelligence, doctoral dissertation 2017, Springer, Heidelberg, ISBN: 978-3-658-20539-3, \url{https://doi.org/10.1007/978-3-658-20540-9}, 2018. 

[Haferlach et al., 2010]  Haferlach, T., Kohlmann, A., Wieczorek, L., Basso, G., Te Kronnie, G., Bene, M.-C., . . . Mills, K. I.: Clinical utility of microarray-based gene expression profiling in the diagnosis and subclassification of leukemia: report from the International Microarray Innovations in Leukemia Study Group, Journal of Clinical Oncology, Vol. 28(15), pp. 2529-2537. 2010.

[Thrun/Ultsch, 2020]  Thrun, M. C., Ultsch, A.: Clustering Benchmark Datasets Exploiting the Fundamental Clustering Problems, Data in Brief, 2020. 
}
\examples{
data(Leukemia)
str(Leukemia)
Cls=Leukemia$Cls
Distance=Leukemia$DistanceMatrix
isSymmetric(Distance)
}
\keyword{datasets}
\keyword{Lsun3D}
\keyword{FCPS}
