#' Extract Coefficients of a FAVAR Model
#'
#'
#' @param object a class 'favar'.
#' @param ... additional arguments affecting the coefficients produced.
#'
#' @return A list\describe{
#' \item{fct_loading}{Factor loading matrix in a factor equation.}
#' \item{varcoef}{regression coefficients in VAR equations.}
#' }
#' @export

coef.favar <- function(object,...){
  if (!inherits(object, 'favar')) stop('\nPlease provide an object of class "favar", generated by "FAVAR()".\n')

  # get factor loading
  fct_loading <- sapply(1:dim(object$Lamb)[2], function(i,x) colMeans(x[,i,]), x = object$Lamb)
  rownames(fct_loading) <- colnames(object$model_info$X)
  colnames(fct_loading) <- rownames(object[["varrlt"]][["sumrlt"]][["varcoef"]])

  # get var ceofficients

  return(list(fct_loading = fct_loading, varcoef = object$varrlt$sumrlt$varcoef))
}
