% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.R
\name{irf}
\alias{irf}
\title{Impulse Response Function for FAVAR}
\usage{
irf(
  fit,
  irftype = "orth",
  tcode = "level",
  resvar = 1,
  impvar = NULL,
  nhor = 10,
  ci = 0.8,
  showplot = TRUE
)
}
\arguments{
\item{fit}{a "favar" object.}

\item{irftype}{\code{'orth'} is orthogonal IRF, and \code{'gen'} is generalized
IRF.}

\item{tcode}{a scalar \code{'level'} or a vector whose length equal \code{ncol(X)+ncol(Y)}.
\code{X,Y} is the parameters of the \code{FAVAR} function. If the variable is taken the
logarithm(\code{'ln'}) or the first difference of logarithm(\code{'Dln'}),
the IRF needs to return to its level value, and you can set the parameters.
Default is \code{'level'}.}

\item{resvar}{It's column indexes in \code{cbind(XY)} that specify response variables.
It's a scalar or a vector. A change variable cause a change of another variable,
and the former is viewed as impulse variable, the latter is viewed as response variable.}

\item{impvar}{Specify a impulse variable. A numeric scalar which is position of variables in VAR equation.
If it's \code{NULL} that is default, its position is the last.}

\item{nhor}{IRF horizon, default is \code{10}.}

\item{ci}{confidence interval, default is 0.8.}

\item{showplot}{whether show figure. \code{TRUE} is default. If multiple pictures would be printed,
the package \code{patchwork} is needed to be loaded.}
}
\value{
A list containing 2 elements. The first element is a object from \code{ggplot2::ggplot}, the
second element is raw data for IRF.
}
\description{
Based on a shock to one standard deviation, compute the IRF.
}
\examples{
# see FAVAR function
}
