% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fava_functions.R
\name{gini_simpson}
\alias{gini_simpson}
\title{Compute the Gini-Simpson index of a compositional vector}
\usage{
gini_simpson(q, K = length(q), S = diag(K))
}
\arguments{
\item{q}{A vector with \code{K=length(q)} non-negative entries that sum to 1.}

\item{K}{Optional; an integer specifying the number of categories in the data. Default is \code{K=length(q)}.}

\item{S}{Optional; a K x K similarity matrix with diagonal elements equal to 1 and off-diagonal elements between 0 and 1. Entry \code{S[i,k]} for \code{i!=k} is the similarity between category and \code{i} and category \code{k}, equalling 1 if the categories are to be treated as identical and equaling 0 if they are to be treated as totally dissimilar. The default value is \code{S = diag(ncol(q))}.}
}
\value{
A numeric value between 0 and 1.
}
\description{
This function computes the Gini-Simpson index, a statistical measure of variability known in population genetics as heterozygosity, of avector of non-negative entries which sum to 1. The function returns a number between 0 and 1 which quantifies the variability of the vector. Values of 0 are achieved when the vector is a permutation of (1,0,..., 0). The value approaches 1 as the number of categories K increases when the vector is equal to (1/K, 1/K, ..., 1/K).
}
\examples{
# Compute unweighted Gini-Simpson index:
gini_simpson(q = c(0.4, 0.3, 0.3))

# Compute Gini-Simpson index assuming that
# categories 1 and 2 are identical:
similarity_matrix = diag(3)
similarity_matrix[1,2] = 1
similarity_matrix[2,1] = 1
gini_simpson(q = c(0.4, 0.3, 0.3), S = similarity_matrix)
}
