% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_AT.R
\name{compute_AT}
\alias{compute_AT}
\title{Given t test results, computing and testing AT1 and AT2, and plotting sub-network}
\usage{
compute_AT(
  edge_t_stat,
  edge_dist_mat,
  network,
  vertex_idx_selected = NULL,
  edge_pair_selected = NULL,
  AT2_perm_test = TRUE,
  num_perm = 500,
  num_cores = parallel::detectCores(),
  type1_name = "Type1",
  type2_name = "Type2",
  subnet_label = "subnet",
  plot_subnet = TRUE,
  save_plot = FALSE,
  save_dir = here::here(),
  ...
)
}
\arguments{
\item{edge_t_stat}{The result from \code{\link[=compute_edge_t_stat]{compute_edge_t_stat()}}.}

\item{edge_dist_mat}{The result from \code{\link[=compute_edge_t_stat]{compute_edge_t_stat()}}.}

\item{network}{An \link[igraph]{igraph-package} graph object. It will be converted to an undirected graph by default.}

\item{vertex_idx_selected}{A numeric vector of vertex indices that you want to include in the sub-network. All edges on the network between these vertices will be included.}

\item{edge_pair_selected}{A character vector of edges that you want to include in the sub-network, each element in the form \emph{"vertex1-vertex2"} (e.g. "1-3").}

\item{AT2_perm_test}{Logical. Whether to conduct permutation test for AT2. If \emph{FALSE}, then p-value of AT2 will be returned as NA.}

\item{num_perm}{Number of permutations in the permutation test.}

\item{num_cores}{Number of cores to register for parallel computing in permutation test. Should be no larger than the number of available cores on the computer.}

\item{type1_name}{The name for phenotype 1, used for naming files of the results.}

\item{type2_name}{The name for phenotype 2.}

\item{subnet_label}{A label for the sub-network, used for naming the files and setting the title in the plot.}

\item{plot_subnet}{Logical. Whether to plot the sub-network.}

\item{save_plot}{Logical. Whether to save the plot of the sub-network.}

\item{save_dir}{Directory to save the results. Results are saved in a subfolder \emph{result_ExprNet} will be created under the directory.}

\item{...}{Parameters for plots. For example, you may specify the size for the vertices and width for the edges.}
}
\value{
A list of the following: \cr
subnet_label: label of the subnet; num_edges: number of edges in the sub-network; \cr
vertex_idx_selected, edge_pair_selected: the sub-network selection arguments provided by you; \cr
t_stat: t statistics of edges in the sub-network, t_stat_perc: percentiles of these t statistics among all edges in the original network; \cr
AT1: Value of AT1; pval_AT1: p-value of AT1; \cr
AT2: Value of AT2; pval_AT2: p-value of AT2)
}
\description{
Given the results from \code{\link[=compute_edge_t_stat]{compute_edge_t_stat()}}, compute AT1 and AT2.
Calculate the p-value of AT1 using the Irwin-Hall (or normal) null distribution and the p-value of AT2 using permutation test.
Plot and save the sub-network.
A red edge indicates that the t statistic of this edge is larger than 0, i.e. mean of its length is larger in phenotype 1 than in phenotype 2. A blue edge indicates the opposite.
}
\examples{
library(ExprNet)
network <- network_demo
data_type1 <- data_LGG_demo
data_type2 <- data_GBM_demo
edge_pair_selected <- c("1-8", "1-15", "2-16", "3-16", "5-10",
                        "5-16", "8-11", "8-13", "8-14", "8-15", "13-15")
save_dir <- tempdir()

# compute the t-statistics and percentiles
res <- compute_edge_t_stat(data_type1, data_type2, network,
                           type1_name = "LGG", type2_name = "GBM", save_dir = save_dir)
edge_t_stat <- res$edge_t_stat
edge_dist_mat <- res$edge_dist_mat

# compute the AT's
compute_AT(edge_t_stat = edge_t_stat, edge_dist_mat = edge_dist_mat, network = network,
           edge_pair_selected = edge_pair_selected,
           AT2_perm_test = TRUE, num_perm = 250, num_cores = 2,
           subnet_label = "Demo_GO0006306_DNA_methylation(LGG-GBM)", save_dir = save_dir,
           vertex.label.cex = 1, vertex.size = 10, edge.width = 7)
}
