% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_color.R
\name{summary_color}
\alias{summary_color}
\title{Summarize the colors present in the segmented area of an image
(Sumarizar as cores presentes na area segmentada de uma imagem).}
\usage{
summary_color(im,
                     segmentation,
                     return=c("image","summary","histogram1","histogram2","histogram3"))
}
\arguments{
\item{im}{:This object must contain an image in EBImage format (Este
objeto deve conter uma imagem no formato do EBImage).}

\item{segmentation}{Binary matrix obtained of a segmentation(matrix binaria obtida por uma segmentacao).}

\item{return}{: Indicates the result you want to obtain from the segmented area in the image
("image","summary","histogram1","histogram2","histogram3")
(Indica o resultado que se deseja obter a partir da area segmentada na imagem).}
}
\value{
Returns an image with the colors present in the segmented area, measures that summarize these colors or histograms
(Retorna uma imagem com as cores presentes na área segmentada, medidas que resumem essas cores ou histogramas).
}
\description{
Summarize the colors present in the segmented area of an image
(Sumarizar as cores presentes na area segmentada de uma imagem).
}
\examples{
im=read_image(example_image(3),plot=TRUE)
r=gray_scale(im,method = "r")
seg=segmentation(img.band = r,threshold = 0.3,selectHigher = FALSE,fillHull = FALSE,plot = TRUE)

summary_color(im,seg,return = "image")
summary_color(im,seg,return = "summary")
summary_color(im,seg,return = "histogram1")
summary_color(im,seg,return = "histogram2")
summary_color(im,seg,return = "histogram3")
}
\seealso{
\code{\link{segmentation} , \link{histogram_image} }
}
