% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WhyperCI_M.R
\name{WhyperCI_M}
\alias{WhyperCI_M}
\title{An Admissible Exact Confidence Interval for M, the Number of White Balls in
an Urn}
\usage{
WhyperCI_M(x, n, N, conf.level, details = FALSE)
}
\arguments{
\item{x}{integer representing the number of white balls in the drawn balls.}

\item{n}{integer representing the number of balls we draw in the urn without
replacement, i.e., the sample size.}

\item{N}{integer representing the number of all balls in an urn, i.e., the
population size.}

\item{conf.level}{the confidence level of confidence interval.}

\item{details}{TRUE/FALSE, can be abbreviate. If choose FALSE, the confidence
interval at the observed X will be returned. If choose TRUE, the confidence
intervals for all sample points and  the infimum coverage probability will
be returned. Default is FALSE.}
}
\value{
a list which contains i) the confidence interval for M, ii)the
confidence interval for p=M/N (this interval is equal to the previous
interval divided by N) and iii) the infimum coverage probability of the two
intervals.
}
\description{
The confidence interval for the number of white balls in an urn
that contains M white balls and  N-M black balls when sampling without
replacement. This function can be used to calculate the interval
constructed method proposed by Wang (2015).
}
\details{
Suppose X~Hyper(M,N,n). When N and n are known, Wang (2015) construct an
admissible confidence interval for N by uniformly shrinking the initial 1-alpha
Clopper-Pearson type interval from  the mid-point of the sample space to 0. This interval
is admissible so that any proper sub-interval of it cannot assure the confidence coefficient. This
means the interval cannot be shortened anymore.
}
\examples{
WhyperCI_M(0,50,2000,0.95,details = TRUE)
WhyperCI_M(0,50,2000,0.95)
}
\references{
Wang, W. (2015). Exact Optimal Confidence Intervals for
Hypergeometric Parameters. "Journal of the American Statistical
Association" 110 (512): 1491-1499.
}
