% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_quantile_trend_graph.R
\name{prepare_quantile_trend_graph}
\alias{prepare_quantile_trend_graph}
\title{Prepares a Quantile Trend Graph}
\usage{
prepare_quantile_trend_graph(df, ts_id, quantiles = c(0.05, 0.25, 0.5, 0.75,
  0.95), var = utils::tail(colnames(df[sapply(df, is.numeric) & colnames(df)
  != ts_id]), n = 1))
}
\arguments{
\item{df}{Data frame containing the ordered factor and the numerical variable
to be plotted}

\item{ts_id}{a string containing the column name of the ordered factor
(normally the time-series indicator)}

\item{quantiles}{a numerical vector containing the quantiles that are to be plotted}

\item{var}{a string containing the column name of the variable
to be plotted. Defaults to the last numerical variable of the data frame
that is not \code{ts_id}.}
}
\value{
A list containing two items:
\describe{
 \item{"df"}{A data frame containing the plotted quantiles}
 \item{"plot"}{The plot as returned by \code{ggplot}}
}
}
\description{
Reads a data frame
and plots the quantiles of the specified variable
by an ordered factor (normally the time-series indicator)
}
\examples{
prepare_quantile_trend_graph(worldbank, "year", var = "SP.DYN.LE00.IN")$plot +
  ggplot2::ylab("Life expectancy at birth world-wide")
df <- data.frame(year = floor(stats::time(datasets::EuStockMarkets)),
                 DAX = datasets::EuStockMarkets[,"DAX"])
graph <- prepare_quantile_trend_graph(df, "year", c(0.05, 0.25, 0.5, 0.75, 0.95))
graph$plot
}
