% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalysis.R
\name{plotMetaAnalysisForest}
\alias{plotMetaAnalysisForest}
\title{Create a forest plot}
\usage{
plotMetaAnalysisForest(
  data,
  labels,
  estimate,
  xLabel = "Relative risk",
  summaryLabel = "Summary",
  limits = c(0.1, 10),
  alpha = 0.05,
  showLikelihood = TRUE,
  fileName = NULL
)
}
\arguments{
\item{data}{A data frame containing either normal, skew-normal, custom parametric, or grid
likelihood data. One row per database.}

\item{labels}{A vector of labels for the data sources.}

\item{estimate}{The meta-analytic estimate as created using either ['computeFixedEffectMetaAnalysis()\verb{] or [}computeBayesianMetaAnalysis()`] function.}

\item{xLabel}{The label on the x-axis: the name of the effect estimate.}

\item{summaryLabel}{The label for the meta-analytic estimate.}

\item{limits}{The limits of the effect size axis.}

\item{alpha}{The alpha (expected type I error).}

\item{showLikelihood}{Show the likelihood curve for each estimate?}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See the
function \link[ggplot2:ggsave]{ggplot2::ggsave} ifor supported file formats.}
}
\value{
A Ggplot object. Use the \link[ggplot2:ggsave]{ggplot2::ggsave} function to save to file.
}
\description{
Creates a forest plot of effect size estimates, including the summary estimate.
}
\details{
Creates a forest plot of effect size estimates, including a meta-analysis estimate.
}
\examples{
# Simulate some data for this example:
populations <- simulatePopulations()
labels <- paste("Data site", LETTERS[1:length(populations)])

# Fit a Cox regression at each data site, and approximate likelihood function:
fitModelInDatabase <- function(population) {
  cyclopsData <- Cyclops::createCyclopsData(Surv(time, y) ~ x + strata(stratumId),
                                            data = population,
                                            modelType = "cox")
  cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
  approximation <- approximateLikelihood(cyclopsFit, parameter = "x", approximation = "custom")
  return(approximation)
}
approximations <- lapply(populations, fitModelInDatabase)
approximations <- do.call("rbind", approximations)

# At study coordinating center, perform meta-analysis using per-site approximations:
estimate <- computeBayesianMetaAnalysis(approximations)
plotMetaAnalysisForest(approximations, labels, estimate)

# (Estimates in this example will vary due to the random simulation)

}
