% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_objects.R
\name{aar_results}
\alias{aar_results}
\alias{AARResults}
\alias{ARResults}
\alias{CAResults}
\title{An R6 object that contains AAR results.}
\format{
\code{\link[R6]{R6Class}} object.

\code{\link[R6]{R6Class}} object.

\code{\link[R6]{R6Class}} object.
}
\description{
An R6 object that contains AAR results.

An R6 object that contains AAR results.

An R6 object that contains AAR results.

An R6 object that contains AAR results.

An R6 object that contains AAR results.

An R6 object that contains AAR results.
}
\section{Methods}{


\describe{
  \item{\code{plot}}{This method plots aar results.}
}



\describe{
  \item{\code{plot}}{This method plots aar results.}
}



\describe{
  \item{\code{plot}}{This method plots aar results.}
}
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{aar_tbl}}{AAR results.}

\item{\code{statistics_tbl}}{AAR test statistic results.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AARResults-new}{\code{AARResults$new()}}
\item \href{#method-AARResults-print}{\code{AARResults$print()}}
\item \href{#method-AARResults-plot}{\code{AARResults$plot()}}
\item \href{#method-AARResults-plot_cumulative}{\code{AARResults$plot_cumulative()}}
\item \href{#method-AARResults-confidence_interval}{\code{AARResults$confidence_interval()}}
\item \href{#method-AARResults-plot_test_statistics}{\code{AARResults$plot_test_statistics()}}
\item \href{#method-AARResults-clone}{\code{AARResults$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AARResults-new"></a>}}
\if{latex}{\out{\hypertarget{method-AARResults-new}{}}}
\subsection{Method \code{new()}}{
Class initialization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AARResults$new(aar_tbl, statistics_tbl)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aar_tbl}}{AAR result table.}

\item{\code{statistics_tbl}}{Table with statistics.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AARResults-print"></a>}}
\if{latex}{\out{\hypertarget{method-AARResults-print}{}}}
\subsection{Method \code{print()}}{
Print key characteristics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AARResults$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AARResults-plot"></a>}}
\if{latex}{\out{\hypertarget{method-AARResults-plot}{}}}
\subsection{Method \code{plot()}}{
Plots AAR results for each analysis group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AARResults$plot(
  group = NULL,
  ci_statistics = NULL,
  p = 0.95,
  ci_type = "two-sided",
  xlab = "Event Window",
  ylab = "Averaged Abnormal Returns",
  facet = T,
  ncol = 4
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{Subset to your analysed groups, else all groups will be plotted.}

\item{\code{ci_statistics}}{Statistic used for confidence intervals}

\item{\code{p}}{The desired p-value}

\item{\code{ci_type}}{type of CI band for ggplot2, available are band or ribbon.}

\item{\code{xlab}}{x-axis label}

\item{\code{ylab}}{y-axis label}

\item{\code{facet}}{should each group get its own plot (default = T)}

\item{\code{ncol}}{number of facet columns}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AARResults-plot_cumulative"></a>}}
\if{latex}{\out{\hypertarget{method-AARResults-plot_cumulative}{}}}
\subsection{Method \code{plot_cumulative()}}{
Plot Cumulative Abnormal Return. No test statistic is available.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AARResults$plot_cumulative(
  xlab = "Event Window",
  ylab = "Cumulative Averaged Abnormal Returns",
  facet = T,
  ncol = 4
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xlab}}{x axis lab}

\item{\code{ylab}}{y axis lab}

\item{\code{facet}}{Shall the plot faceted by Group}

\item{\code{ncol}}{Number of cols when faceting.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AARResults-confidence_interval"></a>}}
\if{latex}{\out{\hypertarget{method-AARResults-confidence_interval}{}}}
\subsection{Method \code{confidence_interval()}}{
Calculates Confidence band for given test statistic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AARResults$confidence_interval(
  statistic = "Patell Z",
  p = 0.95,
  ci_type = "two-sided"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statistic}}{Chosen test statistics for calculation.}

\item{\code{p}}{Chosen p value.}

\item{\code{ci_type}}{Type of confidence interval.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AARResults-plot_test_statistics"></a>}}
\if{latex}{\out{\hypertarget{method-AARResults-plot_test_statistics}{}}}
\subsection{Method \code{plot_test_statistics()}}{
Plots a heatmap with test statistics on y axis and Day Relative to Event on x axis. Colorization is done according to significance according to given p.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AARResults$plot_test_statistics(p = 0.95, ci_type = "two-sided")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{Chosen p value.}

\item{\code{ci_type}}{CI type.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AARResults-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AARResults-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AARResults$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ar_tbl}}{AR result table.
Class initialization}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ARResults-new}{\code{ARResults$new()}}
\item \href{#method-ARResults-print}{\code{ARResults$print()}}
\item \href{#method-ARResults-plot}{\code{ARResults$plot()}}
\item \href{#method-ARResults-clone}{\code{ARResults$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARResults-new"></a>}}
\if{latex}{\out{\hypertarget{method-ARResults-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARResults$new(ar_tbl)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ar_tbl}}{AR result table.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARResults-print"></a>}}
\if{latex}{\out{\hypertarget{method-ARResults-print}{}}}
\subsection{Method \code{print()}}{
Print key characteristics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARResults$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARResults-plot"></a>}}
\if{latex}{\out{\hypertarget{method-ARResults-plot}{}}}
\subsection{Method \code{plot()}}{
Plot abnormal returns in the event window of single or multiple
firms.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARResults$plot(firm = NULL, xlab = "", ylab = "Abnormal Returns", addAAR = F)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{firm}}{set this parameter if just a subset of firms should be plotted}

\item{\code{xlab}}{x-axis label of the plot}

\item{\code{ylab}}{y-axis label}

\item{\code{addAAR}}{add aar line}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a ggplot2 object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ARResults-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ARResults-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ARResults$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{car_tbl}}{Car result table
Class initialization}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CAResults-new}{\code{CAResults$new()}}
\item \href{#method-CAResults-print}{\code{CAResults$print()}}
\item \href{#method-CAResults-clone}{\code{CAResults$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CAResults-new"></a>}}
\if{latex}{\out{\hypertarget{method-CAResults-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CAResults$new(car_tbl)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{car_tbl}}{CAR result table.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CAResults-print"></a>}}
\if{latex}{\out{\hypertarget{method-CAResults-print}{}}}
\subsection{Method \code{print()}}{
Print key characteristics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CAResults$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CAResults-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CAResults-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CAResults$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
