% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultParser.R
\name{ResultParser}
\alias{ResultParser}
\title{Parses request and results files returned from our Event Study API
interface.}
\format{
\code{\link[R6]{R6Class}} object.
}
\description{
This result file parser works currently only with csv files. Please read
the vignette for further details (coming soon). We will restructure our 
result reports soon. So, this function may change dramatically. This object 
can be used for plotting your results.
}
\section{Methods}{


\describe{
  \item{\code{new(dir)}}{This method is used to create object of this class 
  with \code{dir} as the directory of result files.}
  \item{\code{parseReport(path = "analysis_report.csv")}}{This method 
  parses the analysis report file (analysis_report.csv).}
  \item{\code{parseAR(path = "ar_results.csv")}}{This method parses the 
  abnormal return file (ar_results.csv). Furthermore, it triggers 
  \code{parseReport} and join firm and index name.}
  \item{\code{parseCAR(path = "car_results.csv")}}{This method parses the 
  cumulative abnormal return file (ar_results.csv). Furthermore, it triggers 
  \code{parseReport} and join firm and index name.}
}
}

\examples{
\dontrun{
# Assume you already performed an Event Study and result files are saved in 
# the actual working directory.
estParser <- ResultParser$new()

# parse request file
estParser$parseRequestFile("01_RequestFile.csv")

# parse result files
estParser$parseReport("Analysis report.csv")
estParser$parseAR("AR results.csv")
estParser$parseAAR("AAR results.csv")
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ResultParser$new()}}
\item \href{#method-parseRequestFile}{\code{ResultParser$parseRequestFile()}}
\item \href{#method-parseReport}{\code{ResultParser$parseReport()}}
\item \href{#method-parseAR}{\code{ResultParser$parseAR()}}
\item \href{#method-parseCAR}{\code{ResultParser$parseCAR()}}
\item \href{#method-parseAAR}{\code{ResultParser$parseAAR()}}
\item \href{#method-parseCAAR}{\code{ResultParser$parseCAAR()}}
\item \href{#method-calcAARCI}{\code{ResultParser$calcAARCI()}}
\item \href{#method-cumSum}{\code{ResultParser$cumSum()}}
\item \href{#method-createReport}{\code{ResultParser$createReport()}}
\item \href{#method-clone}{\code{ResultParser$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parseRequestFile"></a>}}
\if{latex}{\out{\hypertarget{method-parseRequestFile}{}}}
\subsection{Method \code{parseRequestFile()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$parseRequestFile(path = "01_RequestFile.csv")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parseReport"></a>}}
\if{latex}{\out{\hypertarget{method-parseReport}{}}}
\subsection{Method \code{parseReport()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$parseReport(path = "analysis_report.csv")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parseAR"></a>}}
\if{latex}{\out{\hypertarget{method-parseAR}{}}}
\subsection{Method \code{parseAR()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$parseAR(path = "ar_results.csv", analysisType = "AR")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parseCAR"></a>}}
\if{latex}{\out{\hypertarget{method-parseCAR}{}}}
\subsection{Method \code{parseCAR()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$parseCAR(path = "car_results.csv", analysisType = "CAR")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parseAAR"></a>}}
\if{latex}{\out{\hypertarget{method-parseAAR}{}}}
\subsection{Method \code{parseAAR()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$parseAAR(
  path = "aar_results.csv",
  groups = NULL,
  analysisType = "AAR"
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parseCAAR"></a>}}
\if{latex}{\out{\hypertarget{method-parseCAAR}{}}}
\subsection{Method \code{parseCAAR()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$parseCAAR(
  path = "caar_results.csv",
  groups = NULL,
  analysisType = "AAR"
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-calcAARCI"></a>}}
\if{latex}{\out{\hypertarget{method-calcAARCI}{}}}
\subsection{Method \code{calcAARCI()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$calcAARCI(
  statistic = "Patell Z",
  p = 0.95,
  twosided = T,
  type = "zStatistic"
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cumSum"></a>}}
\if{latex}{\out{\hypertarget{method-cumSum}{}}}
\subsection{Method \code{cumSum()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$cumSum(
  df,
  var = "aar",
  timeVar = NULL,
  cumVar = NULL,
  fun = cumsum
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createReport"></a>}}
\if{latex}{\out{\hypertarget{method-createReport}{}}}
\subsection{Method \code{createReport()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$createReport(file = "EventStudy.xlsx")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultParser$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
