% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr.evaluate.core.R
\name{cr.evaluate.core}
\alias{cr.evaluate.core}
\title{Coincidence Rate of Range}
\usage{
cr.evaluate.core(data, names, quantitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
The \ifelse{html}{\out{<em>CR</em>}}{\eqn{CR}} value.
}
\description{
Compute the Coincidence Rate of Range
(\ifelse{html}{\out{<em>CR</em>}}{\eqn{CR}})
\insertCite{diwan_methods_1995,hu_methods_2000}{EvaluateCore} to compare
quantitative traits of the entire collection (EC) and core set (CS).
}
\details{
The Coincidence Rate of Range (\ifelse{html}{\out{<em>CR</em>}}{\eqn{CR}}) is
computed as follows.

\ifelse{html}{\out{<p style="text-align: center;"><em>CR = <big>(</big>
<sup>1</sup>&frasl;<sub>n</sub> &sum;<sup>n</sup><sub style="line-height:
1.8; margin-left: -1ex;">i=1</sub> <big>[</big>
<sup>R<sub>CS<sub>i</sub></sup> &frasl; <sub>R<sub>EC<sub>i</sub></sub>
<big>]</big><big>)</big> &times; 100</em></p>}}{\deqn{CR = \left (
\frac{1}{n} \sum_{i=1}^{n} \frac{R_{CS_{i}}}{R_{EC_{i}}} \right ) \times
100}}

Where,
\ifelse{html}{\out{<em>R<sub>CS<sub>i</sub></sub></em>}}{\eqn{R_{CS_{i}}}} is
the range of the
\ifelse{html}{\out{<em>i</em>}}{\eqn{i}}th trait in the CS,
\ifelse{html}{\out{<em>R<sub>EC<sub>i</sub></sub></em>}}{\eqn{R_{EC_{i}}}} is
the range of the
\ifelse{html}{\out{<em>i</em>}}{\eqn{i}}th trait in the EC and
\ifelse{html}{\out{<em>n</em>}}{\eqn{n}} is the total number of traits.
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

cr.evaluate.core(data = ec, names = "genotypes",
                 quantitative = quant, selected = core)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{wilcox.test}}
}
