% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_intraday_Data.R
\name{EN_intraday_Data}
\alias{EN_intraday_Data}
\title{Fetches intraday price data for a specified stock on Euronext.}
\usage{
EN_intraday_Data(
  ticker,
  day_type = "Today",
  escape = FALSE,
  stock_type = "Eq_Ind",
  nbitems = 30
)
}
\arguments{
\item{ticker}{A character string representing the stock ticker or name.}

\item{day_type}{A character string specifying the type of intraday price to fetch. Options are "Today" or "Previous" day.
Default is "Today." You can also use 'T' for 'Today' or 'P' for 'Previous'.}

\item{escape}{Boolean, either TRUE or FALSE. If escape is True, it means you're providing the DNA (ISIN-Market identifier) directly. Giving T to escape is helpful to avoid time-consuming operations; otherwise, F means you need to provide the Ticker symbol, name, or ISIN and the type of market to which it belongs.}

\item{stock_type}{The type of the ticker: 'Eq_Ind' for Stocks and Indexes, 'Fund' or "F" for Fund tickers, 'Bond' or "B" for Bond tickers, and 'Etfs' or "E" for EFTs.}

\item{nbitems}{An integer specifying the number of items to fetch. Default is 30 (also the maximum).}
}
\value{
A data frame containing intraday stock information.
}
\description{
This function fetches intraday data for a given stock ticker on Euronext. You can specify the type of intraday price
to retrieve, either "Today" or "Previous" day. The default type is "Today." The function returns a data frame
containing intraday stock information.
}
\examples{
\donttest{

library(httr)
library(jsonlite)
library(rvest)
library(stringr)
library(magrittr)
library(rlang)

# Get recent intraday prices of ABCA share
intra_ = EN_intraday_Data("ABCA", day_type = 'T')
print(intra_)

# Get recent intraday prices of ACOMEA EMERGING Q2 Fund
intra_1 = EN_intraday_Data("IT0005091126", 'F', escape = FALSE, day_type = 'T')
print(intra_1)

# Get Previous intraday prices of ETF AAPL by providing directly the ISIN-Market identifier
intra_2 = EN_intraday_Data("XS2337099563-XAMS", escape = TRUE, day_type = 'Previous')
print(intra_2)

# Get Previous intraday prices of AEX All-Share Index
intra_3 = EN_intraday_Data("AEX All-Share Index GR", day_type = 'P')
print(intra_3)
}

}
\seealso{
\code{\link{EN_GetISIN}}, \code{\link{EN_HistData}}

Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Euronext: 
\code{\link{EN_Get_News}()},
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_plot}()}
}
\concept{Data Retrieval}
\concept{Euronext}
