% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_GetISIN_Etf.R
\name{EN_GetISIN_Etf}
\alias{EN_GetISIN_Etf}
\title{Get the DNA (ISIN and Market identifier) of a ticker from the ETFs list}
\usage{
EN_GetISIN_Etf(ticker)
}
\arguments{
\item{ticker}{The ticker to search for.}
}
\value{
A character
}
\description{
This function checks if the provided ticker is present in the specified columns of the ETFs list. If the ticker is found in the ETFs list, the function returns the DNA (ISIN and Market identifier) of the corresponding ticker. Otherwise, it returns 'Ticker not found'.
}
\examples{

library(httr)
library(jsonlite)
library(rvest)
library(stringr)

the_dna = EN_GetISIN_Etf("AAPL")
sub("-.*", "", the_dna) #To get only the ISIN

# Get ETF '-1X SHORT DIS' DNA
EN_GetISIN_Etf("-1X SHORT DIS")

# Get ETF '3x Long Coinbase' DNA
EN_GetISIN_Etf("XS2399367254")


}
\seealso{
\code{\link{EN_GetISIN}} to get DNA of a giving Company or Index Ticker/Name/ISIN (Fund, Bond, and ETF are excluded), \code{\link{EN_Etfs_List}} to get the list of ETFs quoted on Euronext, \code{\link{EN_GetISIN_B}} to get a giving Bond DNA, \code{\link{EN_GetISIN_F}} to get a giving Fund DNA.

Other ISIN Retrieval: 
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_F}()}

Other Infos Retrieval: 
\code{\link{EN_Bonds_List_bis}()},
\code{\link{EN_Bonds_List}()},
\code{\link{EN_Etfs_List_bis}()},
\code{\link{EN_Etfs_List}()},
\code{\link{EN_Funds_List}()},
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_F}()},
\code{\link{EN_Get_News}()},
\code{\link{EN_Indices_List}()},
\code{\link{EN_Stocks_List}()},
\code{\link{En_Market.Sumarry}()}
}
\concept{ISIN Retrieval}
\concept{Infos Retrieval}
