% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cohorts.R
\name{createCohorts}
\alias{createCohorts}
\title{Construct cohorts}
\usage{
createCohorts(
  connectionDetails,
  cdmDatabaseSchema = "main",
  cohortDatabaseSchema = "main",
  cohortTable = "cohort"
)
}
\arguments{
\item{connectionDetails}{The connection details to connect to the (Eunomia) database.}

\item{cdmDatabaseSchema}{The name of the database schema holding the CDM data.}

\item{cohortDatabaseSchema}{The name of the database schema where the cohorts will be written.}

\item{cohortTable}{The name of the table in the cohortDatabaseSchema where the cohorts
will be written.}
}
\value{
A data frame listing all created cohorts.
}
\description{
Creates a set of predefined cohorts in a cohort table.
WARNING: this will delete all existing cohorts in the table!
}
\examples{
connectionDetails <- getEunomiaConnectionDetails()
createCohorts(connectionDetails)

connection <- connect(connectionDetails)

sql <- "SELECT COUNT(*)
FROM main.cohort
WHERE cohort_definition_id = 1;"

renderTranslateQuerySql(connection, sql)

disconnect(connection)

}
