% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{obs_opts}
\alias{obs_opts}
\title{Observation Model Options}
\usage{
obs_opts(
  family = c("negbin", "poisson"),
  phi = list(mean = 0, sd = 0.25),
  weight = 1,
  week_effect = TRUE,
  week_length = 7,
  scale = 1,
  na = c("missing", "accumulate"),
  likelihood = TRUE,
  return_likelihood = FALSE
)
}
\arguments{
\item{family}{Character string defining the observation model. Options are
Negative binomial ("negbin"), the default, and Poisson.}

\item{phi}{Overdispersion parameter of the reporting process, used only if
\code{familiy} is "negbin". Can be supplied either as a single numeric value
(fixed overdispersion) or a list with numeric elements mean (\code{mean}) and
standard deviation (\code{sd}) defining a normally distributed prior.
Internally parameterised such that the overdispersion is one over the
square of this prior overdispersion. Defaults to a list with elements
\code{mean = 0} and \code{sd = 0.25}.}

\item{weight}{Numeric, defaults to 1. Weight to give the observed data in the
log density.}

\item{week_effect}{Logical defaulting to \code{TRUE}. Should a day of the week
effect be used in the observation model.}

\item{week_length}{Numeric assumed length of the week in days, defaulting to
7 days. This can be modified if data aggregated over a period other than a
week or if data has a non-weekly periodicity.}

\item{scale}{Scaling factor to be applied to map latent infections (convolved
to date of report). Can be supplied either as a single numeric value (fixed
scale) or a list with numeric elements mean (\code{mean}) and standard deviation
(\code{sd}) defining a normally distributed scaling factor. Defaults to 1, i.e.
no scaling.}

\item{na}{Character. Options are "missing" (the default) and "accumulate".
This determines how NA values in the data are interpreted. If set to
"missing", any NA values in the observation data set will be interpreted as
missing and skipped in the likelihood. If set to "accumulate", modelled
observations will be accumulated and added to the next non-NA data point.
This can be used to model incidence data that is reported at less than
daily intervals. If set to "accumulate", the first data point is not
included in the likelihood but used only to reset modelled observations to
zero.}

\item{likelihood}{Logical, defaults to \code{TRUE}. Should the likelihood be
included in the model.}

\item{return_likelihood}{Logical, defaults to \code{FALSE}. Should the likelihood
be returned by the model.}
}
\value{
An \verb{<obs_opts>} object of observation model settings.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Defines a list specifying the structure of the observation
model. Custom settings can be supplied which override the defaults.
}
\examples{
# default settings
obs_opts()

# Turn off day of the week effect
obs_opts(week_effect = TRUE)

# Scale reported data
obs_opts(scale = list(mean = 0.2, sd = 0.02))
}
