% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{new_dist_spec}
\alias{new_dist_spec}
\title{Internal function for generating a \code{dist_spec} given parameters and a
distribution.}
\usage{
new_dist_spec(params, distribution, max = Inf, cdf_cutoff = 0)
}
\arguments{
\item{params}{Parameters of the distribution (including \code{max})}

\item{distribution}{Character; the distribution to use.}

\item{max}{Numeric, maximum value of the distribution. The distribution will
be truncated at this value. Default: \code{Inf}, i.e. no maximum.}

\item{cdf_cutoff}{Numeric; the desired CDF cutoff. Any part of the
cumulative distribution function beyond 1 minus the value of this argument is
removed. Default: \code{0}, i.e. use the full distribution.}
}
\value{
A \code{dist_spec} of the given specification.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This will convert all parameters to natural parameters before generating
a \code{dist_spec}. If they have uncertainty this will be done using sampling.
}
\examples{
new_dist_spec(
  params = list(mean = 2, sd = 1),
  distribution = "normal"
)
}
