% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{plot.dist_spec}
\alias{plot.dist_spec}
\title{Plot PMF and CDF for a dist_spec object}
\usage{
\method{plot}{dist_spec}(x, ...)
}
\arguments{
\item{x}{A \link{dist_spec} object}

\item{...}{Additional arguments to pass to \code{ggplot}}
}
\description{
This function takes a \link{dist_spec} object and plots its probability mass
function (PMF) and cumulative distribution function (CDF) using \link{ggplot2}.
Note that currently uncertainty in distributions is not plot.
}
\examples{
#' # A fixed lognormal distribution with mean 5 and sd 1.
lognormal <- dist_spec(
  mean = 1.6, sd = 0.5, max = 20, distribution = "lognormal"
)
plot(lognormal)

# An uncertain gamma distribution with mean 3 and sd 2
gamma <- dist_spec(
  mean = 3, sd = 2, mean_sd = 0.5, sd_sd = 0.5, max = 20,
  distribution = "gamma"
)
plot(gamma)

# Multiple distributions
plot(lognormal + gamma + lognormal)

# A combination of the two fixed distributions
plot(lognormal + lognormal)
}
\author{
Sam Abbott
}
