% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{add_day_of_week}
\alias{add_day_of_week}
\title{Adds a day of the week vector}
\usage{
add_day_of_week(dates, week_effect = 7)
}
\arguments{
\item{dates}{Vector of dates}

\item{week_effect}{Numeric from 1 to 7 defaults to 7}
}
\value{
A numeric vector containing the period day of the week index
}
\description{
Adds a day of the week vector
}
\examples{
dates <- seq(as.Date("2020-03-15"), by = "days", length.out = 15)
# Add date based day of week
add_day_of_week(dates, 7)

# Add shorter week
add_day_of_week(dates, 4)
}
