% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_infections.R
\name{fit_model_with_nuts}
\alias{fit_model_with_nuts}
\title{Fit a Stan Model using the NUTs sampler}
\usage{
fit_model_with_nuts(
  args,
  future = FALSE,
  max_execution_time = Inf,
  id = "stan"
)
}
\arguments{
\item{args}{List of stan arguments}

\item{future}{Logical, defaults to \code{FALSE}. Should \code{future} be used to run stan chains in parallel.}

\item{max_execution_time}{Numeric, defaults to Inf. What is the maximum execution time per chain in seconds.
Results will still be returned as long as at least 2 chains complete successfully within the timelimit.}

\item{id}{A character string used to assign logging information on error. Used by \code{regional_epinow}
to assign errors to regions. Alter the default to run with error catching.}
}
\value{
A stan model object
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}
Fits a stan model using \code{rstan::sampling}. Provides the optional ability to run chains using
\code{future} with error catching, timeouts and merging of completed chains.
}
