% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveout.R
\name{saveout.icm}
\alias{saveout.icm}
\title{Save icm Data to Output List Format}
\usage{
saveout.icm(dat, s, out = NULL)
}
\arguments{
\item{dat}{Main data object passed through \code{icm} simulations.}

\item{s}{Current simulation number.}

\item{out}{Out list passed back in for updating at simulations 2+.}
}
\value{
A list with the following elements:
\itemize{
\item \strong{param:} the epidemic parameters passed into the model through
\code{\link{param.icm}}, with additional parameters added as
necessary.
\item \strong{control:} the control settings passed into the model through
\code{\link{control.icm}}, with additional controls added as
necessary.
\item \strong{epi:} a list of data frames, one for each epidemiological
output from the model.
}
}
\description{
This function transfers the data from the main \code{dat}
object to the output \code{out} object at the end of each
simulation in \code{\link{icm}}.
}
\keyword{internal}
