% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mutate_epi}
\alias{mutate_epi}
\title{Add New Epidemiology Variables}
\usage{
mutate_epi(x, ...)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{dcm}, \code{icm}, or
\code{netsim}.}

\item{...}{Name-value pairs of expressions (see examples below).}
}
\description{
Inspired by \code{dplyr::mutate}, \code{mutate_epi} adds new
             variables to the epidemiological and related variables within
             simulated model objects of any class in \code{EpiModel}.
}
\examples{
# DCM example
param <- param.dcm(inf.prob = 0.2, act.rate = 0.25)
init <- init.dcm(s.num = 500, i.num = 1)
control <- control.dcm(type = "SI", nsteps = 500)
mod1 <- dcm(param, init, control)
mod1 <- mutate_epi(mod1, prev = i.num/num)
plot(mod1, y = "prev")

# Network model example
nw <- network_initialize(n = 100)
nw <- set_vertex_attribute(nw, "group", rep(1:2, each = 50))
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
est1 <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.3, inf.prob.g2 = 0.15)
init <- init.net(i.num = 1, i.num.g2 = 0)
control <- control.net(type = "SI", nsteps = 10, nsims = 3,
                       verbose = FALSE)
mod1 <- netsim(est1, param, init, control)
mod1

# Add the prevalences to the dataset
mod1 <- mutate_epi(mod1, i.prev = i.num / num,
                         i.prev.g2 = i.num.g2 / num.g2)
plot(mod1, y = c("i.prev", "i.prev.g2"), qnts = 0.5, legend = TRUE)

# Add incidence rate per 100 person years (assume time step = 1 week)
mod1 <- mutate_epi(mod1, ir100 = 5200*(si.flow + si.flow.g2) /
                                      (s.num + s.num.g2))
as.data.frame(mod1)
as.data.frame(mod1, out = "mean")

}
