% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.R
\name{as.data.frame.netdx}
\alias{as.data.frame.netdx}
\title{Extract Timed Edgelists netdx Objects}
\usage{
\method{as.data.frame}{netdx}(x, row.names = NULL, optional = FALSE, sim, ...)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{netdx}.}

\item{row.names}{See \code{\link{as.data.frame.default}}.}

\item{optional}{See \code{\link{as.data.frame.default}}.}

\item{sim}{The simulation number to output. If not specified, then data from
all simulations will be output.}

\item{...}{See \code{\link{as.data.frame.default}}.}
}
\description{
This function extracts timed edgelists for objects of class
             \code{netdx} into a data frame using the generic
             \code{as.data.frame} function.
}
\examples{
# Initialize and parameterize the network model
nw <- network.initialize(n = 100, directed = FALSE)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)

# Model estimation
est <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

# Simulate the network with netdx
dx <- netdx(est, nsims = 3, nsteps = 10, keep.tedgelist = TRUE, verbose = FALSE)

# Extract data from the first simulation
as.data.frame(dx, sim = 1)

# Extract data from all simulations
as.data.frame(dx)

}
\keyword{extract}
