% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.mod.status.R
\name{discord_edgelist}
\alias{discord_edgelist}
\title{Discordant Edgelist from NetworkDynamic Object}
\usage{
discord_edgelist(dat, idsInf, idsSus, at)
}
\arguments{
\item{dat}{Master list object containing a \code{networkDynamic} object and other
initialization information passed from \code{\link{netsim}}.}

\item{idsInf}{Vector of IDs for currently infecteds.}

\item{idsSus}{Vector of IDs for currently susceptible.}

\item{at}{Current time step.}
}
\value{
This function returns a \code{data.frame} with the following columns:
\itemize{
 \item \strong{time:} time step queried
 \item \strong{sus:} ID number for the susceptible partner
 \item \strong{inf:} ID number for the infected partner
}
The output from this function is added to the transmission \code{data.frame}
object that is requested as output in \code{netsim} simulations with
the \code{save.trans=TRUE} argument.
}
\description{
This function returns a \code{data.frame} with a discordant
             edgelist, defined as the set of edges in which the status of the
             two partners is one susceptible and one infected.
}
\details{
This internal function works within the parent \code{\link{infection.net}} function
to pull the current edgelist from the dynamic network object, look up the disease
status of the head and tails on the edge, and subset the list to those edges
with one susceptible and one infected node.
}
\seealso{
\code{\link{netsim}}, \code{\link{infection.net}}
}
\keyword{internal}
\keyword{netMod}
