% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dcm}
\alias{dcm}
\title{Deterministic Compartmental Models}
\usage{
dcm(param, init, control)
}
\arguments{
\item{param}{model parameters, as an object of class \code{\link{param.dcm}}.}

\item{init}{initial conditions, as an object of class \code{\link{init.dcm}}.}

\item{control}{control settings, as an object of class
       \code{\link{control.dcm}}.}
}
\value{
A list of class \code{dcm} with the following elements:
\itemize{
 \item \strong{param:} the epidemic parameters passed into the model through
       \code{param}, with additional parameters added as necessary.
 \item \strong{control:} the control settings passed into the model through,
       \code{control}, with additional controls added as necessary.
 \item \strong{epi:} a list of of data frames, one for each epidemiological
       output from the model. Outputs for built-in models always include the
       size of each compartment, as well as flows in, out, and between
       compartments.
}
}
\description{
Solves deterministic compartmental epidemic models for
             infectious disease.
}
\details{
The \code{dcm} function uses the ordinary differential equation solver in
the \code{deSolve} package to model disease as a deterministic compartmental
system. The parameterization for these models follows the standard approach in
\code{EpiModel}, with epidemic parameters, initial conditions, and control
settings. A description of solving DCMs with the \code{dcm} function may be
found in the \href{http://statnet.org/EpiModel/vignette/Tutorial.pdf}{EpiModel
Tutorial}.

The \code{dcm} function performs  modeling of both built-in model types and
original models with new structures. Built-in model types include one-group
and two-group models with disease types for Susceptible-Infected (SI),
Susceptible-Infected-Recovered (SIR), and Susceptible-Infected-Susceptible (SIS).
New model types may be written and input into \code{dcm} following the steps
outlined in the \href{http://statnet.org/EpiModel/vignette/NewDCMs.html}{Solving
New DCMs with EpiModel} tutorial. Both built-in and original models require
the \code{param}, \code{init}, and \code{control} inputs.
}
\examples{
## Example 1: SI Model (One-Group)
# Set parameters
param <- param.dcm(inf.prob = 0.2, act.rate = 0.25)
init <- init.dcm(s.num = 500, i.num = 1)
control <- control.dcm(type = "SI", nsteps = 500)
mod1 <- dcm(param, init, control)
mod1
plot(mod1)

## Example 2: SIR Model with Vital Dynamics (One-Group)
param <- param.dcm(inf.prob = 0.2, act.rate = 5,
                   rec.rate = 1/3, b.rate = 1/90, ds.rate = 1/100,
                   di.rate = 1/35, dr.rate = 1/100)
init <- init.dcm(s.num = 500, i.num = 1, r.num = 0)
control <- control.dcm(type = "SIR", nsteps = 500)
mod2 <- dcm(param, init, control)
mod2
plot(mod2)

## Example 3: SIS Model with act.rate Sensitivity Parameter
param <- param.dcm(inf.prob = 0.2, act.rate = seq(0.1, 0.5, 0.1),
                   rec.rate = 1/50)
init <- init.dcm(s.num = 500, i.num = 1)
control <- control.dcm(type = "SIS", nsteps = 500)
mod3 <- dcm(param, init, control)
mod3
plot(mod3)

## Example 4: SI Model with Vital Dynamics (Two-Group)
param <- param.dcm(inf.prob = 0.4,  inf.prob.g2 = 0.1,
                   act.rate = 0.25, balance = "g1",
                   b.rate = 1/100, b.rate.g2 = NA,
                   ds.rate = 1/100, ds.rate.g2 = 1/100,
                   di.rate = 1/50, di.rate.g2 = 1/50)
init <- init.dcm(s.num = 500, i.num = 1,
                 s.num.g2 = 500, i.num.g2 = 0)
control <- control.dcm(type = "SI", nsteps = 500)
mod4 <- dcm(param, init, control)
mod4
plot(mod4)
}
\references{
Soetaert K, Petzoldt T, Setzer W. Solving Differential Equations in R: Package
deSolve. Journal of Statistical Software. 2010; 33(9): 1-25.
\url{http://www.jstatsoft.org/v33/i09/}.
}
\seealso{
Extract the model results with \code{\link{as.data.frame.dcm}}.
Summarize the time-specific model results with \code{\link{summary.dcm}}.
Plot the model results with \code{\link{plot.dcm}}. Plot a compartment flow
diagram with \code{\link{comp_plot}}.
}
\keyword{model}

