% Generated by roxygen2 (4.0.1): do not edit by hand
\name{control.dcm}
\alias{control.dcm}
\title{Control Settings for Deterministic Compartmental Models}
\usage{
control.dcm(type, nsteps, dt, odemethod, new.mod, print.mod, verbose, ...)
}
\arguments{
\item{type}{disease type to be modeled, with the choice of \code{"SI"} for
Susceptible-Infected diseases, \code{"SIR"} for
Susceptible-Infected-Recovered diseases, and \code{"SIS"} for
Susceptible-Infected-Susceptible diseases.}

\item{nsteps}{number of time steps to solve the model over. This must be a
positive integer.}

\item{dt}{time unit for model solutions, with the default of 1. Model
solutions for fractional time steps may be obtained by setting this to a
number between 0 and 1.}

\item{odemethod}{ordinary differential equation (ODE) integration method, with
the default of the "Runge-Kutta 4" method (see \code{\link{ode}} for
other options).}

\item{new.mod}{if not running a built-in model type, a function with a new
model to be simulated (see details).}

\item{print.mod}{if \code{TRUE}, print the model form to the console.}

\item{verbose}{if \code{TRUE}, print model progress to the console.}

\item{...}{additional control settings passed to model.}
}
\description{
Sets the controls for deterministic compartmental models
             simulated with \code{\link{dcm}}.
}
\details{
\code{control.dcm} sets the required control settings for any deterministic
compartmental models solved with the \code{\link{dcm}} function. Controls are
required for both built-in model types and original models. For an overview of
control settings for built-in DCM class models, consult the
\href{http://statnet.org/EpiModel/vignette/Tutorial.pdf}{EpiModel Tutorial}.
For all built-in models, the \code{type} argument is a necessary parameter
and it has no default.
}
\section{New Model Functions}{

The form of the model function for built-in models may be displayed with the
\code{print.mod} argument set to \code{TRUE}. In this case, the model will not
be run. These model forms may be used as templates to write original model
functions.

These new models may be input and solved with \code{\link{dcm}} using the
\code{new.mod} argument, which requires as input a model function. Details and
examples are found in the \href{http://statnet.org/EpiModel/vignette/NewDCMs.html}{Solving
New DCMs with EpiModel} tutorial.
}
\seealso{
Use \code{\link{param.dcm}} to specify model parameters and
         \code{\link{init.dcm}} to specify the initial conditions. Run the
         parameterized model with \code{\link{dcm}}.
}
\keyword{parameterization}

