% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aso_charlson_score.R
\name{charlson_score}
\alias{charlson_score}
\title{Charlson Score Constructor}
\usage{
charlson_score(
  data,
  Person_ID,
  diagnosis_variable,
  time_variable = NULL,
  end_date = NULL,
  days_before_end_date = NULL,
  amount_output = "total"
)
}
\arguments{
\item{data}{A data.frame with at least an id variable and a variable with all
diagnosis codes. The data should be in the long format (only one variable
with diagnoses, but several lines per person is OK).}

\item{Person_ID}{<\code{\link[=dplyr_data_masking]{data-masking}}> An unquoted
expression naming the id variable in \code{data}. This variable must always be
specified.}

\item{diagnosis_variable}{<\code{\link[=dplyr_data_masking]{data-masking}}> An unquoted
expression naming the diagnosis variable in \code{data}. This variable must
always be specified.}

\item{time_variable}{<\code{\link[=dplyr_data_masking]{data-masking}}> An unquoted
expression naming the diagnosis time variable in \code{data} if needed. The
\code{time_variable} must be in a date format.

When \code{time_variable} is specified, \code{end_date} must also be specified.}

\item{end_date}{<\code{\link[=dplyr_data_masking]{data-masking}}> An unquoted
expression naming the end of time-period to search for relevant diagnoses
or a single date specifying the end date. If \code{end_date} names a variable,
this variable must be in a date format.}

\item{days_before_end_date}{A numeric specifying the number of days look-back
from \code{end_date} to search for relevant diagnoses.}

\item{amount_output}{A character specifying whether all created index
variables should be returned. When \code{amount_output} is "total" (the default)
only the resulting Charlson scores are returned, otherwise all disease-
specific index variables are returned.}
}
\value{
If \code{Person_ID} and \code{diagnosis_variable} are the only specifications, the
function will calculate the different versions of the Charlson score on all
data available for each person, regardless of timing etc. This is OK if only
relevant records are included.
}
\description{
Charlson comorbidity score for Danish ICD-10 and ICD-8 data. This is a
SAS-macro ASO translated to R in March of 2022
}
\details{
The \code{charlson_score()} function calculates the Charlson Charlson Comorbidity
Index for each person. Three different variations on the score has been
implemented:

\itemize{
\item cc: Article from Quan et al. (Coding Algorithms for Defining
Comorbidities in ICD-9 and ICD-10 Administrative Data, Med Care 2005:43:
1130-1139), the same HTR and others have used - ICD10 only
\item ch: Article from Christensen et al. (Comparison of Charlson
comorbidity index with SAPS and APACHE sources for prediction of mortality
following intensive care, Clinical Epidemiology 2011:3 203-211), include
ICD8 and ICD10 but the included diagnoses are not the same as in Quan
\item cd: Article from Sundarajan et al. (New ICD-10 version of Charlson
Comorbidity Index predicted in-hospital mortality, Journal of clinical
Epidemiology 57 (2004) 1288-1294, include ICD10 = Charlson-Deyo including
cancer
}
}
\section{NOTE}{
The diagnoses to use in this function at the current state should be either
ICD-8, but preferably ICD-10. The ICD-10 codes should start with two letters,
where the first one is "D". Furthermore, the code should only have letters
and digits (i.e. the form "DA000" not "DA00.0")
}

\examples{
\donttest{

# An example dataset

test_data <- data.frame(
  IDs = c(
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
    17, 18, 19, 20, 21, 22, 22, 23, 23, 24, 24, 24, 24, 24
  ),
  Diags = c(
    "DZ36", "DZ38", "DZ40", "DZ42", "DC20", "DI252",
    "DP290", "DI71", "DH340", "DG30", "DJ40", "DM353",
    "DK26", "DK700", "DK711", "DE106", "DE112", "DG82",
    "DZ940", "DC80", "DB20", "DK74", "DK704", "DE101",
    "DE102", "DB20", "DK74", "DK704", "DE101", "DE102"
 ),
 time = as.Date(c(
   "2001-01-30", "2004-05-20", "2007-01-02", "2013-12-01",
   "2017-04-30", "2001-01-30", "2004-05-20", "2007-01-02",
   "2013-12-01", "2017-04-30", "2001-01-30", "2004-05-20",
   "2007-01-02", "2013-12-01", "2017-04-30", "2001-01-30",
   "2004-05-20", "2007-01-02", "2013-12-01", "2017-04-30",
   "2001-01-30", "2004-05-20", "2007-01-02", "2013-12-01",
   "2017-04-30", "2001-01-30", "2004-05-20", "2007-01-02",
   "2013-12-01", "2017-04-30"
 )),
 match_date = as.Date(c(
   "2001-10-15", "2005-10-15", "2011-10-15", "2021-10-15",
   "2021-10-15", "2001-10-15", "2005-10-15", "2011-10-15",
   "2021-10-15", "2021-10-15", "2001-10-15", "2005-10-15",
   "2011-10-15", "2021-10-15", "2021-10-15", "2001-10-15",
   "2005-10-15", "2011-10-15", "2021-10-15", "2021-10-15",
   "2001-10-15", "2005-10-15", "2011-10-15", "2021-10-15",
   "2021-10-15", "2001-10-15", "2005-10-15", "2011-10-15",
   "2021-10-15", "2021-10-15"
 ))
)

# Minimal example
charlson_score(
  data = test_data,
  Person_ID = IDs,
  diagnosis_variable = Diags
)

# Minimal example with all index diagnosis variables
charlson_score(
  data = test_data,
  Person_ID = IDs,
  diagnosis_variable = Diags,
  amount_output = "all"
)

# Imposing uniform date restrictions to diagnoses
charlson_score(
  data = test_data,
  Person_ID = IDs,
  diagnosis_variable = Diags,
  time_variable = time,
  end_date = as.Date("2012-01-01")
)

# Imposing differing date restriction to diagnoses
charlson_score(
  data = test_data,
  Person_ID = IDs,
  diagnosis_variable = Diags,
  time_variable = time,
  end_date = match_date
)

# Imposing both a start and end to the lookup period for
# relevant diagnoses
charlson_score(
  data = test_data,
  Person_ID = IDs,
  diagnosis_variable = Diags,
  time_variable = time,
  end_date = match_date,
  days_before_end_date = 365.25
)
}

}
\author{
ASO & ADLS
}
