% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kija_discrete_covariates_to_onehot.R
\name{DiscreteCovariatesToOneHot}
\alias{DiscreteCovariatesToOneHot}
\title{One-hot encode factors}
\usage{
DiscreteCovariatesToOneHot(df, factors = dplyr::everything())
}
\arguments{
\item{df}{A data frame, data frame extension (e.g. a tibble), or a lazy data
frame (e.g. from dbplyr or dtplyr).}

\item{factors}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> One or more unquoted
expressions naming factors in df to one-hot encode.}
}
\value{
Data frame with one-hot encoded factors. One-hot encoded columns
have names \verb{\{fct_nm\}_\{lvl_nm\}}.
}
\description{
Convert factors in a data frame to one-hot encoding.
}
\examples{
mtcars |>
dplyr::mutate(dplyr::across(c(2, 8:11), factor)) |>
 as.data.frame() |>
 DiscreteCovariatesToOneHot(cyl)
mtcars |>
dplyr::mutate(dplyr::across(c(2, 8:11), factor)) |>
 as.data.frame() |>
 DiscreteCovariatesToOneHot(c(2, 8:11))

}
\author{
KIJA
}
