rateplot <-
function( rates,
          which = c("ap","ac","pa","ca"),
            age = as.numeric( dimnames( rates )[[1]] ),
            per = as.numeric( dimnames( rates )[[2]] ),
           grid = FALSE,
         a.grid = grid,
         p.grid = grid,
         c.grid = grid,
          ygrid = grid,
       col.grid = gray( 0.9 ),
          a.lim = range( age, na.rm=TRUE ) + c(0,diff( range( age ) )/30),
          p.lim = range( per, na.rm=TRUE ) + c(0,diff( range( age ) )/30),
          c.lim = NULL, 
           ylim = range( rates[rates>0] ),
             at = NULL,
         labels = paste( at ),
          a.lab = "Age at diagnosis",
          p.lab = "Date of diagnosis",
          c.lab = "Date of birth",
           ylab = "Rates",
           type = "l",
            lwd = 2,
            lty = 1,
         log.ax = "y",
            las = 1,
            ann = FALSE,
          a.ann = ann,
          p.ann = ann,
          c.ann = ann,
          xannx = 1/20,
        cex.ann = 0.8,
         a.thin = seq( 1, length( age ), 2 ),
         p.thin = seq( 1, length( per ), 2 ),
         c.thin = seq( 2, length( age ) + length( per ) - 1, 2 ),
            col = par( "fg" ),
          a.col = col,
          p.col = col,
          c.col = col,
            ... )
{
# Remove 0 rates, in order to avoid warnings
rates[rates==0] <- NA
# then do the plots
for( i in 1:length( which ) )
    {      
    if( toupper( which[i] ) == "AP" )
       Aplot( rates,
                age = age,                                      
                per = per,                                      
             a.grid = a.grid,                                   
              ygrid = ygrid,                                    
           col.grid = col.grid,                                 
              a.lim = a.lim,                                    
               ylim = ylim,                                     
              a.lab = a.lab,                                    
               ylab = ylab,                                     
                 at = at,
             labels = labels,
               type = type,                                     
                lwd = lwd,                                      
                lty = lty,                                      
                col = col,                                      
             log.ax = log.ax,                                   
                las = las,                                      
              p.ann = p.ann,
              xannx = xannx,
              p.col = p.col,                                    
            cex.ann = cex.ann,                                  
             p.thin = p.thin,                                   
            p.lines = TRUE,                                     
            c.lines = FALSE,
                ... )
    
    if( toupper( which[i] ) == "AC" )
       Aplot( rates,
                age = age,                                          
                per = per,                                      
             a.grid = a.grid,                                   
              ygrid = ygrid,                                    
           col.grid = col.grid,                                  
              a.lim = a.lim,                                    
               ylim = ylim,                                     
              a.lab = a.lab,                                    
               ylab = ylab,                                     
                 at = at,
             labels = labels,
               type = type,                                     
                lwd = lwd,                                      
                lty = lty,                                      
                col = col,                                      
             log.ax = log.ax,                                   
                las = las,                                      
              c.ann = c.ann,                                    
              p.ann = p.ann,                                    
              xannx = xannx,
              c.col = c.col,                                    
              p.col = p.col,                                    
            cex.ann = cex.ann,                                  
             c.thin = c.thin,                                   
            p.lines = FALSE,                                     
            c.lines = TRUE,
                ... )                                    
    
    if( toupper( which[i] ) %in% c("APC","ACP") )
       Aplot( rates,            
                age = age,          
                per = per,      
             a.grid = a.grid,   
              ygrid = ygrid,    
           col.grid = col.grid,  
              a.lim = a.lim,    
               ylim = ylim,     
              a.lab = a.lab,    
               ylab = ylab,     
                 at = at,
             labels = labels,
               type = type,     
                lwd = lwd,      
                lty = lty,      
                col = col,      
             log.ax = log.ax,   
                las = las,      
              c.ann = c.ann,    
              p.ann = p.ann,    
              xannx = xannx,
              c.col = c.col,    
              p.col = p.col,    
            cex.ann = cex.ann,  
             c.thin = c.thin,   
             p.thin = p.thin,   
            p.lines = TRUE,     
            c.lines = TRUE,
                ... )               
   
    if( toupper( which[i] ) == "PA" )
       Pplot( rates,
                age = age,
                per = per,
               grid = grid,
             p.grid = p.grid,
              ygrid = ygrid,
           col.grid = col.grid,
              p.lim = p.lim,
               ylim = ylim,
              p.lab = p.lab,
               ylab = ylab,
                 at = at,
             labels = labels,
               type = type,
                lwd = lwd,
                lty = lty,
                col = col,
             log.ax = log.ax,
                las = las,
                ann = a.ann,
              xannx = xannx,
            cex.ann = cex.ann,
             a.thin = a.thin,
                ... )

    if( toupper( which[i] ) == "CA" )
       Cplot( rates,
                age = age,
                per = per,
               grid = grid,
             c.grid = c.grid,
              ygrid = ygrid,
           col.grid = col.grid,
              c.lim = c.lim,
               ylim = ylim,
              c.lab = c.lab,
               ylab = ylab,
                 at = at,
             labels = labels,
               type = type,
                lwd = lwd,
                lty = lty,
                col = col,
             log.ax = log.ax,
                las = las,
                ann = a.ann,
              xannx = xannx,
            cex.ann = cex.ann,
             a.thin = a.thin,
                ... )
    
    }
}
