% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.model1.R
\name{elo.model1}
\alias{elo.model1}
\title{Optimize k parameter in Elo rating method}
\usage{
elo.model1(par, burn_in=100, init_elo = 1000, IA_data, all_ids, p_function = "sigmoid", 
  return_likelihood = T)
}
\arguments{
\item{par}{initial value of log(k)}

\item{burn_in}{burn in period for establishing initial elo scores. Defaults to 100}

\item{init_elo}{Initial Elo score for all individuals.  Defaults to 1000}

\item{IA_data}{Data frame with Date, Winner, and Loser}

\item{all_ids}{list of all IDs in sample}

\item{p_function}{function used to calculate probability of winning.  Defaults to sinusoidal 
function, but use "pnorm" to use the \code{\link[stats:Normal]{pnorm}}-based method 
implemented in the EloRating package.}

\item{return_likelihood}{Logical; if TRUE, returns log likelihood based on given par, if FALSE
returns agonistic interactions table with elo scores based on given value of par}
}
\description{
Function to optimize k parameter in Elo Rating Method
}
\examples{
#for internal use

}
