% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_logabsdet}
\alias{Eigen_logabsdet}
\title{Logarithm of the absolute value of the determinant}
\usage{
Eigen_logabsdet(M)
}
\arguments{
\item{M}{a \emph{real} square matrix}
}
\value{
The logarithm of the absolute value of the determinant of \code{M}.
}
\description{
Logarithm of the absolute value of the determinant of a real 
  matrix.
}
\note{
`Eigen_logabsdet(M)` is not faster than `log(abs(Eigen_det(M)))`.
}
\examples{
set.seed(666L)
M <- matrix(rpois(25L, 1), 5L, 5L)
Eigen_logabsdet(M)
}
