% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseMatrix.R
\name{SparseMatrix}
\alias{SparseMatrix}
\alias{print.SparseMatrix}
\alias{asSparseMatrix}
\title{Sparse matrix}
\usage{
SparseMatrix(i, j, Mij, nrows, ncols)

\method{print}{SparseMatrix}(x, ...)

asSparseMatrix(M)
}
\arguments{
\item{i, j}{indices of the non-zero coefficients}

\item{Mij}{values of the non-zero coefficients; must be a vector of the same 
length as \code{i} and \code{j} or a single number which will be recycled}

\item{nrows, ncols}{dimensions of the matrix}

\item{x}{a \code{SparseMatrix} object}

\item{...}{ignored}

\item{M}{a matrix, real or complex}
}
\value{
A list with the class \code{SparseMatrix}.
}
\description{
Constructs a sparse matrix, real or complex.
}
\examples{
set.seed(666)
( M <- matrix(rpois(50L, 1), 10L, 5L) )
asSparseMatrix(M)
}
