% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBB_2012.R
\name{readBB_2012}
\alias{readBB_2012}
\title{Connect to B&B 2008--2012 Data}
\usage{
readBB_2012(
  path,
  csvFilename = "b12derived_datafile.csv",
  formatFilename = "b12derived_format.txt",
  metadataFilename = "b12derived_metadata.txt"
)
}
\arguments{
\item{path}{a character value to the root directory path containing the \code{csvFilename}, \code{formatFilename}, and \code{metadataFilename} data files.}

\item{csvFilename}{a character value of the derived data file (.csv) containing the raw B&B 2008--2012 data.}

\item{formatFilename}{a character value of the format file (.txt) that describes the layout of the \code{csvFilename}.}

\item{metadataFilename}{a character value of the metadata file (.txt) that describes additional metadata of the \code{csvFilename}.}
}
\value{
an \code{edsurvey.data.frame} for the B&B 2008--2012 longitudinal dataset.
}
\description{
Opens a connection to a Baccalaureate & Beyond 2008--2012 data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the specified \code{csvFilename} file for the B&B 2008--2012 longitudinal survey to an \code{edsurvey.data.frame}.
}
\examples{
\dontrun{
# using default filenames
bb <- readBB_2012(path = "C:/BB/2012")
dim(bb)

# parameters specified without default filenames
bb <- readBB_2012(path = getwd(),
                  csvFilename = "renamedData.csv",
                  formatFilename = "renamedFormat.txt",
                  metadataFilename = "renamedMeta.txt")
dim(bb)
}
}
\seealso{
\code{\link{readECLS_K2011}}, \code{\link{readNAEP}}, and \code{\link{getData}}
}
\author{
Tom Fink
}
