% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTALIS.R
\name{readTALIS}
\alias{readTALIS}
\title{Connect to TALIS Data}
\usage{
readTALIS(path, countries, isced, dataLevel = "teacher",
  forceReread = FALSE, verbose = TRUE)
}
\arguments{
\item{path}{a character value to the full directory to the TALIS SPSS files (.sav)}

\item{countries}{a character vector of the country/countries to include using the 
three-digit ISO country code. A list of country codes can be found in the TALIS codebook or you can use
\url{https://en.wikipedia.org/wiki/ISO_3166-1#Current_codes}.
You can use \code{*} to indicate all countries available.}

\item{isced}{a character value that is one of \code{a}, \code{b}, or \code{c}. \code{a} stands for \emph{Primary Level}, 
\code{b} is for \emph{Lower Secondary Level}; and, \code{c} is for \emph{Upper Secondary Level}.}

\item{dataLevel}{a character value that indicates which data level to be used. It can be \code{teacher} (the default) or \code{school}.}

\item{forceReread}{a logical value to force rereading of all processed data. Defaults to \code{FALSE}.
Setting \code{forceReread} to be \code{TRUE} will cause PISA data to be reread and increase processing time.}

\item{verbose}{a logical value that will determine if you want verbose output while the function is running to indicate the progress.
Defaults to \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for a single specified country or 
  an \code{edsurvey.data.frame.list} if multiple countries specified
}
\description{
Opens a connection to a TALIS data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the unzipped files downloaded from the TALIS database using the OECD Repository (\url{http://www.oecd.org/skills/piaac/}).
       If \code{dataLevel} is set to be \code{teacher}, it treats the teacher data file as the main dataset and merges school data into teacher data for
       each country. If \code{dataLevel} is \code{school}, it uses only the school data file. To conduct a school-level analysis with teacher variables,
       it is recommended that users aggregate teacher-level data first before merging it to school files.
}
\examples{
\dontrun{
# The following call returns an edsurvey.data.frame to TALIS 2013 
# for US teacher-level data at secondary level
usa2013 <- readTALIS(path = "C:/TALIS/2013", isced = "b",
                     dataLevel = "teacher", countries = "usa")

# Extract a data.frame with a few variables
gg <- getData(usa2013, c("tt2g05b", "tt2g01"))  
head(gg)

# Conduct a preliminary analysis on the edsurvey.data.frame
edsurveyTable(tt2g05b ~ tt2g01, data = usa2013) 
}
}
\references{
OECD. (2014a). \emph{TALIS 2013 technical report}. Paris, France: OECD Publishing. Retrieved from \emph{\url{http://www.oecd.org/education/school/TALIS-technical-report-2013.pdf}}
}
\seealso{
\code{\link{getData}} and \code{\link{downloadTALIS}}
}
\author{
Trang Nguyen
}
