% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stouffer_Z_score.R
\name{stouffer_zscore}
\alias{stouffer_zscore}
\title{Stouffer}
\usage{
stouffer_zscore(pvals, weights = rep(1, seq_along(pvals)), side = "two")
}
\arguments{
\item{pvals}{A vector of p-values}

\item{weights}{A vector of weights}

\item{side}{How the p-values were generated. One of 'right',
'left' or 'two'.}
}
\value{
A list containing the following components:
\itemize{
\item \emph{statistic} the value of the test statistic.
\item \emph{p.value} the p-value of the test.
}
}
\description{
Stouffer's Z-score method
}
\details{
Given a set of i.i.d p-values and associated weights, it combines the
p-values \eqn{p_i}. Letting \eqn{\phi} be the standard normal cumulative distribution function
and \eqn{Z_i =\phi^{-1} (1-p_i)}, the meta-analysis Z-score is

\deqn{Z = (\sum w_i Z_i) * (\sum (w_i)^2)^(-1/2)}
}
\examples{
 pvals <- runif(100, 0, 1)
 weights <- runif(100, 0, 1)
 stouffer_zscore(pvals, weights)
}
\references{
Samuel Andrew Stouffer. \emph{Adjustment during army life}.  Princeton University Press, 1949.
}
