% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotEcotone.R
\name{plotEcotone}
\alias{plotEcotone}
\title{Plot method for EcotoneFinder}
\usage{
plotEcotone(data = NULL, slope = NULL, env = NULL,
  plot.data = FALSE, plot.method = c("none", "dca", "fanny",
  "vegclust", "cmeans", "diversity", "dca_slope", "fanny_slope",
  "vegclust_slope", "cmeans_slope", "diversity_slope"), axis.number = 1,
  magnification = 20, magnification.diversity = 5,
  magnification.slope = 500, col.data = "black",
  col.method = c("red", "blue"), col.slope = c("darkgreen", "green"),
  col.env = c("orange", "gold"), title = NULL, ylab = "Species",
  xlab = "Gradient", na.rm = FALSE, ...)
}
\arguments{
\item{data}{A list containing elements named in the same way than
EcotoneFinder function outcomes}

\item{slope}{A list containing elements named in the same way than Slope
function outcomes}

\item{env}{A list containing elements named in the same way than
EcotoneFinder function outcomes. Usefull if EcotoneFinder has been
run on environmental data and the outcomes are to be compared with
the outcomes from the community matrix. Can also be used to compare
results from two different community matrices, if the x-axis are
similar.}

\item{plot.data}{Logical. Should the data be plotted.}

\item{plot.method}{Analysis method to be plotted from the EcotoneFinder
results or the Slope results. Must be one or several of
"none","dca","fanny","vegclust", "cmeans","diversity",
"dca_slope","fanny_slope","vegclust_slope", "cmeans_slope" or
"diversity_slope".}

\item{axis.number}{Number of axis to plot from the DCA.}

\item{magnification}{Magnification coefficient for the method. Usefull if the
data are being plotted.}

\item{magnification.diversity}{Particular magnification for the diversity
indices.}

\item{magnification.slope}{Magnification coefficient for the Slope.}

\item{col.data}{Colors to be used for the data. See CommunityColor function.}

\item{col.method}{Colors to be used for the methods (for data).}

\item{col.slope}{Colors to be used for the methods (for slope).}

\item{col.env}{Colors to be used for the methods (for env).}

\item{title}{An overall title for the plot. See plot.}

\item{ylab}{A title for the y-axis. See plot.}

\item{xlab}{A title for the x-axis. See plot.}

\item{na.rm}{Logical. Should NAs be removed.}

\item{...}{Additional argument to be passed to the plot function.}
}
\value{
A plot corresponding to the plotEcotone arguments.
}
\description{
Plot method for EcotoneFinder
}
\details{
The plotEcotone function is intended for easy visualisation of the
  results of the EcotoneFinder function and the Slope function along the
  sampling gradient. It also provide a way to plot the original species data
  - for comparison - along with magnification coefficients for the different
  method or slopes in order to facilitate visualization. Please note that
  large sets of species may be confusing to plot. The CommunityColor function
  is also provided to help with data coloring and easy visualisation.
}
\examples{
 ######## Artificial dataset & analysis:
 SyntheticTrial <- SyntheticData(SpeciesNum = 20, CommunityNum = 3,
                                 SpCo = NULL, Length = 500,
                                 Parameters = list(a=rep(60, 3),
                                                   b=c(0,250,500),
                                                   c=rep(0.03,3)),
                                 dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

 SyntheticEcoFinder <- EcotoneFinder(SyntheticTrial[,-1],
                                     dist = SyntheticTrial$Distance,
                                     method = "all", groups = 3,
                                     standardize = "hellinger",
                                     diversity = "all")

 ##### Assigning colors to communities:
 SyntheticColor <- CommunityColor(SyntheticEcoFinder, pal = "diverge_hcl",
                                  method = "cmeans")

 ###### Computing the derivatives:
 SyntheticSlope <- Slope(SyntheticEcoFinder, method = "all",
                         axis.number = 2, diversity = "all")

 ####### Plot the derivative of the FCM with the synthetic species data:
 require(colorspace)
 plotEcotone(slope = SyntheticSlope, plot.data = TRUE,
             plot.method = c("cmeans_slope"), axis.number = 2,
             col.method = terrain_hcl(3), col.data = SyntheticColor)

 ####### Plot the derivative and the FCM:
 require(colorspace)
 plotEcotone(data = SyntheticEcoFinder, slope = SyntheticSlope,
             plot.data = TRUE,
             plot.method = c("cmeans", "cmeans_slope"),
             axis.number = 2, col.method = terrain_hcl(3),
             col.data = SyntheticColor)



}
